package com.atlassian.beehive;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

import javax.annotation.Nonnull;

import com.atlassian.annotations.PublicApi;

/**
 * Represents a cluster-wide lock.
 * <p>
 *     These are named locks available from {@code com.atlassian.beehive.ClusterLockService}.
 * </p>
 *
 * @see java.util.concurrent.locks.Lock
 */
@PublicApi
public interface ClusterLock extends Lock
{
    /**
     * Queries if this lock is held by the current thread.
     * <p>
     * This is equivalent to {@link Thread#holdsLock(Object)} for Java's intrinsic
     * monitor locks or {@link java.util.concurrent.locks.ReentrantLock#isHeldByCurrentThread()}.
     *
     * @return {@code true} if the current thread holds this lock; {@code false} otherwise
     */
    boolean isHeldByCurrentThread();

    /**
     * This optional operation from the java {@code Lock} interface is not supported in ClusterLock.
     * @return never
     *
     * @throws java.lang.UnsupportedOperationException always
     */
    @Nonnull
    @Override
    Condition newCondition();
}
