/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.xcode.hockeyapp;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plugins.xcode.hockeyapp.CountingMultipartEntity;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class UploadTask
implements CommonTaskType {
    private static final String HOCKEY_URL = "https://rink.hockeyapp.net/api/2/apps/upload";

    public TaskResult execute(@NotNull CommonTaskContext commonTaskContext) throws TaskException {
        BuildLogger buildLogger = commonTaskContext.getBuildLogger();
        String apiToken = (String)commonTaskContext.getConfigurationMap().get((Object)"apitoken");
        buildLogger.addBuildLogEntry("Using API Token: " + apiToken);
        TaskResultBuilder taskResult = TaskResultBuilder.newBuilder((CommonTaskContext)commonTaskContext);
        PostMethod method = this.createPostRequest(commonTaskContext, buildLogger, apiToken);
        if (method != null && this.sendPostRequest(method, buildLogger).booleanValue()) {
            taskResult.success();
        } else {
            taskResult.failed();
        }
        return taskResult.build();
    }

    private PostMethod createPostRequest(CommonTaskContext commonTaskContext, BuildLogger buildLogger, String apiToken) {
        String notify;
        PostMethod method = new PostMethod(HOCKEY_URL);
        method.addRequestHeader("X-HockeyAppToken", apiToken);
        HashSet parts = Sets.newHashSet();
        String ipaPath = (String)commonTaskContext.getConfigurationMap().get((Object)"ipa");
        if (!this.addIPAPart(commonTaskContext, parts, ipaPath).booleanValue()) {
            buildLogger.addBuildLogEntry("Could not load the specified IPA file '" + ipaPath + "'");
            return null;
        }
        String dsymPath = (String)commonTaskContext.getConfigurationMap().get((Object)"dsym");
        if (!StringUtils.isEmpty((String)dsymPath) && !this.addDSYMPart(commonTaskContext, parts, dsymPath)) {
            buildLogger.addBuildLogEntry("Could not load the specified dSYM file '" + dsymPath + "'");
            return null;
        }
        String notes = (String)commonTaskContext.getConfigurationMap().get((Object)"notes");
        parts.add(new StringPart("notes", notes));
        String download = (String)commonTaskContext.getConfigurationMap().get((Object)"download");
        parts.add(new StringPart("status", download.equalsIgnoreCase("true") ? "2" : "1"));
        String tags = (String)commonTaskContext.getConfigurationMap().get((Object)"tags");
        if (tags != null && tags.length() > 0) {
            parts.add(new StringPart("tags", tags));
        }
        parts.add(new StringPart("notify", (notify = (String)commonTaskContext.getConfigurationMap().get((Object)"notify")).equalsIgnoreCase("true") ? "1" : "0"));
        HttpMethodParams params = new HttpMethodParams();
        MultipartRequestEntity requestEntity = new MultipartRequestEntity(parts.toArray(new Part[parts.size()]), params);
        CountingMultipartEntity countingEntity = new CountingMultipartEntity((RequestEntity)requestEntity, this.getLogListener(buildLogger, requestEntity.getContentLength()));
        method.setRequestEntity((RequestEntity)countingEntity);
        return method;
    }

    private Boolean sendPostRequest(PostMethod method, BuildLogger buildLogger) {
        HttpClient client = new HttpClient();
        try {
            buildLogger.addBuildLogEntry("Uploading build to HockeyApp...");
            int status = client.executeMethod((HttpMethod)method);
            if (status == 201) {
                buildLogger.addBuildLogEntry("Upload completed!");
                return true;
            }
            String body = method.getResponseBodyAsString();
            buildLogger.addErrorLogEntry("Upload failed with response:");
            buildLogger.addErrorLogEntry(body);
            return false;
        }
        catch (IOException e) {
            buildLogger.addErrorLogEntry("Upload failed with IOException: " + e.getLocalizedMessage());
            return false;
        }
    }

    private CountingMultipartEntity.ProgressListener getLogListener(final BuildLogger buildLogger, final long totalSize) {
        return new CountingMultipartEntity.ProgressListener(){
            private long lastSize = 0L;

            @Override
            public void transferred(long size) {
                if ((long)((double)this.lastSize / (double)totalSize * 10.0) < (long)((double)size / (double)totalSize * 10.0)) {
                    buildLogger.addBuildLogEntry("Upload progress: " + (long)((double)size / (double)totalSize * 100.0) + "%");
                }
                this.lastSize = size;
            }
        };
    }

    private boolean addDSYMPart(CommonTaskContext commonTaskContext, Set<Part> parts, String dsymPath) {
        File pathToFile = new File(commonTaskContext.getWorkingDirectory(), dsymPath);
        try {
            parts.add((Part)new FilePart("dsym", pathToFile));
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    private Boolean addIPAPart(CommonTaskContext commonTaskContext, Set<Part> parts, String ipaPath) {
        File pathToFile = new File(ipaPath);
        try {
            parts.add((Part)new FilePart("ipa", pathToFile));
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }
}

