/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.xcode.build;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.BuildTaskRequirementSupport;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskTestResultsSupport;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementImpl;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import com.atlassian.struts.TextProvider;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XCodeConfigurator
extends AbstractTaskConfigurator
implements BuildTaskRequirementSupport,
TaskTestResultsSupport {
    public static final String TARGET = "target";
    public static final String ALL_TARGETS = "alltargets";
    public static final String CONFIGURATION = "configuration";
    public static final String SDK = "label";
    public static final String CLEAN = "clean";
    public static final String PROJECT = "projectname";
    public static final String WORKSPACE = "workspacename";
    public static final String SCHEME = "schemename";
    public static final String ARCH = "archname";
    public static final String WORKING_SUB_DIR = "workingSubDirectory";
    public static final String LOGFILE = "logfile";
    public static final String CLEAN_LOGFILE = "cleanLogfile";
    public static final String CUSTOM_PARAMETERS = "customParameters";
    public static final String ENVIRONMENT = "environmentVariables";
    public static final String OCUNIT = "ocunit";
    public static final String XCUNIT = "xcunit";
    public static final String BUILD_IPA = "build_ipa";
    public static final String APP_PATH = "app_path";
    public static final String IDENTITY = "identity";
    public static final String PROVISIONING_PROFILE = "provisioning_profile";
    public static final String RUN_TESTS_IN_IOS_SIM = "run_in_ios_sim";
    public static final String TEST_SIM = "test_sim";
    public static final String DEVELOPMENT_TEAM = "development_team";
    public static final String RESET_SIMULATOR = "reset_simulator";
    public static final String DISTRIBUTION_METHOD = "distributionMethod";
    public static final String DISTRIBUTION_METHODS = "distributionMethods";
    public static final String DEFAULT_DISTRIBUTION_METHOD = "development";
    public static final String INCLUDE_SYMBOLS = "includeSymbols";
    public static final String INCLUDE_BITCODE = "includeBitcode";
    private static final String CTX_UI_CONFIG_BEAN = "uiConfigBean";
    private static final Set<String> FIELDS_TO_COPY = ImmutableSet.builder().add((Object)"target").add((Object)"alltargets").add((Object)"configuration").add((Object)"projectname").add((Object)"workspacename").add((Object)"schemename").add((Object)"archname").add((Object)"label").add((Object)"clean").add((Object)"workingSubDirectory").add((Object)"logfile").add((Object)"cleanLogfile").add((Object)"customParameters").add((Object)"environmentVariables").add((Object)"ocunit").add((Object)"xcunit").add((Object)"build_ipa").add((Object)"identity").add((Object)"provisioning_profile").add((Object)"app_path").add((Object)"run_in_ios_sim").add((Object)"test_sim").add((Object)"development_team").add((Object)"reset_simulator").add((Object)"distributionMethod").add((Object)"includeSymbols").add((Object)"includeBitcode").build();
    protected TextProvider textProvider;
    protected UIConfigSupport uiConfigSupport;

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.populateContextForAllOperations(context);
        this.taskConfiguratorHelper.populateContextWithConfiguration(context, taskDefinition, FIELDS_TO_COPY);
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        this.populateContextForAllOperations(context);
        context.put(DISTRIBUTION_METHOD, DEFAULT_DISTRIBUTION_METHOD);
        context.put(ALL_TARGETS, true);
        context.put(CLEAN, true);
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map map = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(map, params, FIELDS_TO_COPY);
        return map;
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        if (StringUtils.isEmpty((String)params.getString(SDK))) {
            errorCollection.addError(SDK, this.textProvider.getText("xcode.sdk.error"));
        }
        if (params.getBoolean(BUILD_IPA)) {
            if (StringUtils.isEmpty((String)params.getString(APP_PATH))) {
                errorCollection.addError(APP_PATH, this.textProvider.getText("xcode.app_path.error"));
            }
            if (StringUtils.isEmpty((String)params.getString(DEVELOPMENT_TEAM))) {
                errorCollection.addError(DEVELOPMENT_TEAM, this.textProvider.getText("xcode.development_team.error"));
            }
        }
        if (StringUtils.isNotEmpty((String)params.getString(WORKSPACE)) && StringUtils.isEmpty((String)params.getString(SCHEME))) {
            errorCollection.addError(SCHEME, this.textProvider.getText("xcode.scheme.error"));
        }
        if (StringUtils.isEmpty((String)params.getString(DISTRIBUTION_METHOD))) {
            errorCollection.addError(DISTRIBUTION_METHOD, this.textProvider.getText("xcode.distribution_method.error"));
        }
    }

    @NotNull
    public Set<Requirement> calculateRequirements(@NotNull TaskDefinition taskDefinition, @NotNull Job job) {
        String sdk = (String)taskDefinition.getConfiguration().get(SDK);
        Preconditions.checkNotNull((Object)sdk, (Object)"No SDK was selected");
        return Sets.newHashSet((Object[])new Requirement[]{new RequirementImpl("system.builder.xcode." + sdk, true, ".*")});
    }

    private void populateContextForAllOperations(@NotNull Map<String, Object> context) {
        context.put(DISTRIBUTION_METHODS, this.getDistributionMap());
        context.put(CTX_UI_CONFIG_BEAN, this.uiConfigSupport);
    }

    public boolean taskProducesTestResults(@NotNull TaskDefinition taskDefinition) {
        String ocunit = (String)taskDefinition.getConfiguration().get(OCUNIT);
        String xcunit = (String)taskDefinition.getConfiguration().get(XCUNIT);
        return Boolean.parseBoolean(ocunit) || Boolean.parseBoolean(xcunit);
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    public void setUiConfigSupport(UIConfigSupport uiConfigSupport) {
        this.uiConfigSupport = uiConfigSupport;
    }

    private Map<String, String> getDistributionMap() {
        LinkedHashMap<String, String> distributionMap = new LinkedHashMap<String, String>();
        distributionMap.put("app-store", "Application Store");
        distributionMap.put("enterprise", "Enterprise");
        distributionMap.put("ad-hoc", "Ad-Hoc");
        distributionMap.put(DEFAULT_DISTRIBUTION_METHOD, "Development");
        return distributionMap;
    }
}

