/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.xcode.build;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.process.BambooProcessHandler;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ErrorStreamToBuildLoggerOutputHandler;
import com.atlassian.bamboo.process.ExternalProcessViaBatchBuilder;
import com.atlassian.bamboo.process.StreamToBuildLoggerOutputHandler;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.OutputHandler;
import com.atlassian.utils.process.ProcessHandler;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class FastlaneTaskType
implements CommonTaskType {
    private final CapabilityContext capabilityContext;
    private final EnvironmentVariableAccessor environmentVariableAccessor;

    public FastlaneTaskType(@ComponentImport CapabilityContext capabilityContext, @ComponentImport EnvironmentVariableAccessor environmentVariableAccessor) {
        this.capabilityContext = capabilityContext;
        this.environmentVariableAccessor = environmentVariableAccessor;
    }

    @NotNull
    public TaskResult execute(@NotNull CommonTaskContext taskContext) throws TaskException {
        try {
            ConfigurationMap configurationMap = taskContext.getConfigurationMap();
            String builderLabel = (String)configurationMap.get((Object)"label");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)builderLabel), (Object)"Builder label is not defined");
            String capabilityKey = String.format("%s.%s", "system.builder.fastlane", builderLabel);
            String fastlanePath = (String)Preconditions.checkNotNull((Object)this.capabilityContext.getCapabilityValue(capabilityKey), (Object)String.format("Path is not defined for [%s.%s]", "system.builder.fastlane", builderLabel));
            ExternalProcessViaBatchBuilder externalProcessViaBatchBuilder = new ExternalProcessViaBatchBuilder();
            externalProcessViaBatchBuilder.command((List)Lists.newArrayList((Object[])new String[]{fastlanePath, (String)configurationMap.get((Object)"lane")}), taskContext.getWorkingDirectory());
            externalProcessViaBatchBuilder.forceBatch();
            ResultKey resultKey = taskContext.getCommonContext().getResultKey();
            StreamToBuildLoggerOutputHandler stdOut = new StreamToBuildLoggerOutputHandler(taskContext.getBuildLogger(), resultKey);
            ErrorStreamToBuildLoggerOutputHandler errOut = new ErrorStreamToBuildLoggerOutputHandler(taskContext.getBuildLogger(), resultKey);
            externalProcessViaBatchBuilder.handler((ProcessHandler)new BambooProcessHandler((OutputHandler)stdOut, (OutputHandler)errOut));
            externalProcessViaBatchBuilder.env(this.createEnvironmentMap(configurationMap));
            ExternalProcess fastlaneProcess = externalProcessViaBatchBuilder.build();
            fastlaneProcess.execute();
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).checkReturnCode(fastlaneProcess).build();
        }
        catch (Exception e) {
            throw new TaskException("Could not execute Fastlane task", (Throwable)e);
        }
    }

    private Map<String, String> createEnvironmentMap(ConfigurationMap configurationMap) {
        String environmentVariables = StringUtils.defaultString((String)((String)configurationMap.get((Object)"environmentVariables")));
        return this.environmentVariableAccessor.splitEnvironmentAssignments(environmentVariables, false);
    }
}

