[#macro repositoryUnsupportedWarning supportedRepositories=[]]
    [@ui.messageBox type="warning"]
        <p>[@s.text name="vcs.common.error.unsupported.repository"/]</p>
        [#if supportedRepositories?has_content]
            <p>[@s.text name="vcs.common.supported.repositories"/]</p>
            <ul>
                [#list supportedRepositories as supportedRepository]
                    <li>${supportedRepository}</li>
                [/#list]
            </ul>
        [/#if]
    [/@ui.messageBox]
[/#macro]

[#macro repositorySelect availableRepositories deploymentMode defaultRepositoryKey='' defaultRepositoryName='']
    [#local defaultRepositoryAllowed = !deploymentMode && defaultRepositoryKey?has_content && defaultRepositoryName?has_content /]

    [#if defaultRepositoryAllowed]
        [@s.select labelKey='vcs.checkout.repository' name='selectedRepository' required=true
            list=availableRepositories listKey='key' listValue='value'
            headerKey=defaultRepositoryKey headerValue=(action.getText('vcs.checkout.repository.default.title') + ' (' + defaultRepositoryName + ')')/]
    [#else]
        [@s.select labelKey='vcs.checkout.repository' name='selectedRepository' required=true
            list=availableRepositories listKey='key' listValue='value'/]
    [/#if]

    [#if deploymentMode]
        [@s.textfield labelKey='vcs.common.checkout.location' name='workingSubDirectory' cssClass="long-field" /]
    [/#if]
[/#macro]
