[#-- @ftlvariable name="action" type="com.atlassian.bamboo.plugins.vcs.task.configuration.VcsCheckoutTaskConfigurator" --]
[#-- @ftlvariable name="" type="com.atlassian.bamboo.plugins.vcs.task.configuration.VcsCheckoutTaskConfigurator" --]

[#macro removeButton]
<div class="aui-toolbar inline">
    <ul class="toolbar-group">
        <li class="toolbar-item">
            <a class="aui-button toolbar-trigger">[@ww.text name="global.buttons.remove" /]</a>
        </li>
    </ul>
</div>
[/#macro]

[@ww.text name='vcs.checkout.workingDirNotSelectable' var='workingDirNoSelectable'/]
[@ww.text name='vcs.checkout.checkoutDirectoryInUse' var='checkoutDirectoryInUse' /]

[#macro repoSnippet index=0]
    [#if index!=0]
        [@removeButton /]
    [/#if]

    [#if deploymentMode]
        [#--[#if repositories.size() lt 2]--]
            [#--[@ww.select labelKey='vcs.checkout.repository' name='selectedRepository_${index}' required=true toggle=true/]--]
        [#--[#else]--]
            [@ww.select labelKey='vcs.checkout.repository' name='selectedRepository_${index}' list='repositories' cssClass='long-field' required=true toggle=true/]
        [#--[/#if]--]
    [#else]
        [#if repositories.size() lt 2]
            [@ww.select labelKey='vcs.checkout.repository' name='selectedRepository_${index}' headerKey=defaultRepositoryKey headerValue=defaultRepositoryName cssClass='long-field' required=true toggle=true/]
        [#else]
            [@ww.select labelKey='vcs.checkout.repository' name='selectedRepository_${index}' list='repositories' headerKey=defaultRepositoryKey headerValue=(action.getText('vcs.checkout.repository.default.title') + " (" + defaultRepositoryName + ")") cssClass='long-field' required=true toggle=true/]
        [/#if]
    [/#if]
    [@ui.bambooSection dependsOn="selectedRepository_${index}" showOn="${customWorkingDirectoryAwareRepositories}"]
        [@ww.textfield name="checkoutDir_${index}" labelKey="vcs.checkout.directory" cssClass="long-field checkout-directory"/]
    [/@ui.bambooSection]
    [@ui.bambooSection dependsOn="selectedRepository_${index}" showOn="${repositoriesUsingLegacySourceDirectory}"]
        [@ww.label labelKey="vcs.checkout.directory" value=workingDirNoSelectable/]
    [/@ui.bambooSection]
[/#macro]

[#if !deploymentMode]
<p>[#rt]
        [@ww.text name="vcs.checkout.description"]
    [@ww.param][@ww.url namespace='/chain/admin/config' action='editChainRepository' buildKey=immutableBuild.parent.key /][/@ww.param]
[/@ww.text][#t]
</p>[#lt]
[#else]
    [@ui.messageBox titleKey="vcs.checkout.deployment.description.title" closeable=true]
        <p>[@ww.text name='vcs.checkout.deployment.description'/]</p>
    [/@ui.messageBox]
[/#if]

<ul id="checkout-list">
[#list selectedRepositoriesIndices?sort as index]
    <li data-checkout-id="${index}">[@repoSnippet index /]</li>
[/#list]
</ul>

[@ww.checkbox name="cleanCheckout" labelKey="vcs.checkout.cleanCheckout"/]
<a id="checkout-add">[@ww.text name="vcs.checkout.repository.add"/]</a>

<script type="text/x-template" title="checkout-list-item-template">
[#assign repoSnippetInst][@repoSnippet 869576137068/][/#assign]
    <li data-checkout-id="{index}">${repoSnippetInst?replace("869576137068", "{index}")}</li>
</script>

<script type="text/javascript">
    BAMBOO.REPOSITORY.CheckoutTaskConfiguration.init({
                                                         addCheckoutSelector: "#checkout-add",
                                                         checkoutListSelector: "#checkout-list",
                                                         checkoutDirectorySelector: ".checkout-directory:visible",
                                                         templates: {
                                                             checkoutListItem: "checkout-list-item-template"
                                                         },
                                                         i18n: {
                                                             checkoutDirectoryInUse: "${checkoutDirectoryInUse?js_string}"
                                                         }
                                                     });
</script>
