/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.vcs.task.utils;

import com.atlassian.bamboo.deployments.execution.DeploymentTaskContext;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooPreconditions;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CommonContext;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class VcsTaskUtils {
    private VcsTaskUtils() {
    }

    @NotNull
    public static File getCheckoutDirectory(@NotNull CommonTaskContext taskContext, long repositoryId) throws TaskException {
        CommonContext commonContext = taskContext.getCommonContext();
        BuildContext buildContext = (BuildContext)Narrow.downTo((Object)commonContext, BuildContext.class);
        if (buildContext != null) {
            String checkoutLocation = (String)buildContext.getCheckoutLocation().get(repositoryId);
            BambooPreconditions.checkThat((boolean)StringUtils.isNotEmpty((CharSequence)checkoutLocation), TaskException::new, (String)"Could not determine checkout location of repository with id %d", (Object[])new Object[]{repositoryId});
            return new File(checkoutLocation);
        }
        return taskContext.getWorkingDirectory();
    }

    public static void appendAffectedCommits(long repositoryId, @NotNull String revisionId, @NotNull CommonTaskContext commonTaskContext) {
        if (commonTaskContext instanceof TaskContext) {
            TaskContext taskContext = (TaskContext)commonTaskContext;
            taskContext.getBuildContext().getBuildResult().getVcsWorkingCopyState().addCommit(repositoryId, revisionId);
        } else if (commonTaskContext instanceof DeploymentTaskContext) {
            DeploymentTaskContext deploymentTaskContext = (DeploymentTaskContext)commonTaskContext;
            deploymentTaskContext.getDeploymentContext().getCurrentResult().getVcsWorkingCopyState().addCommit(repositoryId, revisionId);
        }
    }
}

