/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.vcs.task.export;

import com.atlassian.bamboo.plugins.vcs.task.configuration.VcsTagTaskConfigurator;
import com.atlassian.bamboo.plugins.vcs.task.export.AbstractVcsTaskExporter;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.task.VcsTagTask;
import com.atlassian.bamboo.specs.model.task.VcsTagTaskProperties;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VcsTagTaskExporter
extends AbstractVcsTaskExporter {
    private static final ValidationContext VALIDATION_CONTEXT = ValidationContext.of((String)"VCS Tag Task");

    @Override
    @NotNull
    protected ValidationContext getValidationContext() {
        return VALIDATION_CONTEXT;
    }

    @Override
    protected boolean isRepositoryTypeSupported(@NotNull VcsRepositoryModuleDescriptor moduleDescriptor) {
        return new VcsTagTaskConfigurator().isRepositoryModuleSupported(moduleDescriptor);
    }

    @NotNull
    public Map<String, String> toTaskConfiguration(@NotNull TaskContainer taskContainer, @NotNull TaskProperties taskProperties) {
        Map<String, String> configuration = this.baseVcsTaskToConfiguration(taskContainer, taskProperties);
        VcsTagTaskProperties typedTaskProperties = this.getTypedTaskProperties(taskProperties, VcsTagTaskProperties.class);
        configuration.put("tagName", typedTaskProperties.getTagName());
        return configuration;
    }

    @NotNull
    public VcsTagTask toSpecsEntity(@NotNull TaskDefinition taskDefinition) {
        Map configuration = taskDefinition.getConfiguration();
        return this.baseVcsTaskToSpecsEntity(taskDefinition, new VcsTagTask()).tagName((String)configuration.get("tagName"));
    }

    @NotNull
    public List<ValidationProblem> validate(@NotNull TaskValidationContext taskValidationContext, @NotNull TaskProperties taskProperties) {
        return this.baseVcsTaskValidate(taskValidationContext, taskProperties);
    }
}

