/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.vcs.task.export;

import com.atlassian.bamboo.configuration.external.helpers.RepositoryReferenceHelper;
import com.atlassian.bamboo.plugins.vcs.task.configuration.VcsCheckoutTaskConfigurator;
import com.atlassian.bamboo.plugins.vcs.task.export.AbstractVcsTaskExporter;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.model.plan.PlanProperties;
import com.atlassian.bamboo.specs.api.model.repository.PlanRepositoryLinkProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.task.CheckoutItem;
import com.atlassian.bamboo.specs.builders.task.VcsCheckoutTask;
import com.atlassian.bamboo.specs.model.task.CheckoutItemProperties;
import com.atlassian.bamboo.specs.model.task.VcsCheckoutTaskProperties;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.export.TaskDefinitionExporter;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import com.atlassian.bamboo.task.repository.RepositoryTaskHelper;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.DescriptionProvider;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.acegisecurity.acls.Permission;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class VcsCheckoutTaskExporter
extends AbstractVcsTaskExporter
implements TaskDefinitionExporter {
    private static final ValidationContext VALIDATION_CONTEXT = ValidationContext.of((String)"VCS Checkout");
    @Autowired
    private BambooPermissionManager permissionManager;

    @Override
    @NotNull
    protected ValidationContext getValidationContext() {
        return VALIDATION_CONTEXT;
    }

    @Override
    protected boolean isRepositoryTypeSupported(@NotNull VcsRepositoryModuleDescriptor moduleDescriptor) {
        return true;
    }

    @NotNull
    public Task toSpecsEntity(@NotNull TaskDefinition taskDefinition) {
        Map taskConfiguration = taskDefinition.getConfiguration();
        VcsCheckoutTask taskBuilder = new VcsCheckoutTask();
        taskConfiguration.keySet().stream().filter(arg_0 -> ((Predicate)RepositoryTaskHelper.isRepositorySelector).apply(arg_0)).sorted((Comparator<String>)RepositoryTaskHelper.orderingOfRepositorySelectors).forEach(selectorKey -> {
            String indexString = selectorKey.substring(VcsCheckoutTaskConfigurator.CFG_SELECTED_REPOSITORY_ID_PREFIX.length());
            CheckoutItem checkoutItemBuilder = this.isDefaultRepositoryRef((String)selectorKey, taskConfiguration) ? new CheckoutItem().defaultRepository() : new CheckoutItem().repository(this.getNonDefaultRepositoryRef((String)selectorKey, taskConfiguration));
            taskBuilder.checkoutItems(new CheckoutItem[]{checkoutItemBuilder.path(StringUtils.defaultString((String)((String)taskConfiguration.get(VcsCheckoutTaskConfigurator.CFG_CHECKOUT_DIR_PREFIX + indexString))))});
        });
        taskBuilder.cleanCheckout(Boolean.valueOf((String)taskConfiguration.get("cleanCheckout")).booleanValue());
        return taskBuilder;
    }

    @NotNull
    public Map<String, String> toTaskConfiguration(@NotNull TaskContainer taskContainer, @NotNull TaskProperties taskProperties) {
        VcsCheckoutTaskProperties checkoutTaskProperties = (VcsCheckoutTaskProperties)Narrow.downTo((Object)taskProperties, VcsCheckoutTaskProperties.class);
        if (checkoutTaskProperties != null) {
            HashMap<String, String> cfg = new HashMap<String, String>();
            cfg.put("cleanCheckout", Boolean.toString(checkoutTaskProperties.isCleanCheckout()));
            int index = 0;
            for (CheckoutItemProperties checkoutItem : checkoutTaskProperties.getCheckoutItems()) {
                String indexString = Integer.toString(index);
                if (checkoutItem.isDefaultRepository()) {
                    cfg.put(VcsCheckoutTaskConfigurator.CFG_SELECTED_REPOSITORY_ID_PREFIX + indexString, RepositoryTaskHelper.CFG_DEFAULT_REPOSITORY);
                } else {
                    String repositoryIdString = this.getRepositoryIdString(checkoutItem.getRepository(), taskContainer);
                    cfg.put(VcsCheckoutTaskConfigurator.CFG_SELECTED_REPOSITORY_ID_PREFIX + indexString, repositoryIdString);
                }
                cfg.put(VcsCheckoutTaskConfigurator.CFG_CHECKOUT_DIR_PREFIX + indexString, checkoutItem.getPath());
                ++index;
            }
            return cfg;
        }
        throw new IllegalStateException("Don't know how to import task properties of type: " + taskProperties.getClass().getName());
    }

    @NotNull
    public List<ValidationProblem> validate(@NotNull TaskValidationContext taskValidationContext, @NotNull TaskProperties taskProperties) {
        VcsCheckoutTaskProperties checkoutTaskProperties = (VcsCheckoutTaskProperties)Narrow.downTo((Object)taskProperties, VcsCheckoutTaskProperties.class);
        if (checkoutTaskProperties == null) {
            return Collections.singletonList(new ValidationProblem(VALIDATION_CONTEXT, "Don't know how to validate task properties of type: " + taskProperties.getClass().getName()));
        }
        ArrayList<ValidationProblem> problems = new ArrayList<ValidationProblem>();
        if (taskValidationContext.getOwnerPlan().isPresent()) {
            this.validateForPlan(taskValidationContext, checkoutTaskProperties, problems);
        } else {
            this.validateForDeployment(checkoutTaskProperties, problems);
        }
        HashSet<String> usedPaths = new HashSet<String>();
        for (CheckoutItemProperties checkoutItem : checkoutTaskProperties.getCheckoutItems()) {
            if (usedPaths.contains(checkoutItem.getPath())) {
                problems.add(new ValidationProblem(VALIDATION_CONTEXT.with("Checkout item").with("path"), "Path " + checkoutItem.getPath() + " used more than once"));
            }
            usedPaths.add(checkoutItem.getPath());
        }
        return problems;
    }

    private void validateForDeployment(VcsCheckoutTaskProperties checkoutTaskProperties, List<ValidationProblem> problems) {
        HashSet<Long> usedRepositories = new HashSet<Long>();
        for (CheckoutItemProperties checkoutItem : checkoutTaskProperties.getCheckoutItems()) {
            Optional<VcsRepositoryData> deploymentRepository;
            if (checkoutItem.isDefaultRepository()) {
                problems.add(new ValidationProblem(VALIDATION_CONTEXT, "Default repository is not defined for deployments"));
            }
            if (!(deploymentRepository = this.findReferencedLinkedRepositoryByName(checkoutItem.getRepository().getName())).isPresent()) {
                problems.add(new ValidationProblem(VALIDATION_CONTEXT.with("Checkout item"), "Linked repository: " + checkoutItem.getRepository() + " cannot be found. Available repositories are: " + this.getAvailableLinkedRepositories()));
                continue;
            }
            if (!this.userHasReadPermissionToRepository(deploymentRepository.get())) {
                problems.add(new ValidationProblem(VALIDATION_CONTEXT.with("Checkout item"), "Don't have READ permission to repository %s", new Object[]{checkoutItem.getRepository().getName()}));
            }
            if (usedRepositories.add(deploymentRepository.get().getId())) continue;
            problems.add(new ValidationProblem(VALIDATION_CONTEXT.with("Checkout item"), "Repository " + checkoutItem.getRepository() + " used more than once"));
        }
    }

    @NotNull
    private Optional<VcsRepositoryData> findReferencedLinkedRepositoryByName(@Nullable String name) {
        return Optional.ofNullable(name).map(arg_0 -> ((RepositoryDefinitionManager)this.repositoryDefinitionManager).getLinkedRepositoryByName(arg_0));
    }

    private String getAvailableLinkedRepositories() {
        return this.repositoryDefinitionManager.getLinkedRepositories().stream().filter(this::userHasReadPermissionToRepository).map(DescriptionProvider::getName).collect(Collectors.joining(", "));
    }

    private void validateForPlan(@NotNull TaskValidationContext taskValidationContext, VcsCheckoutTaskProperties checkoutTaskProperties, List<ValidationProblem> problems) {
        boolean defaultRepositoryAlreadyReferenced = false;
        HashSet<VcsRepositoryProperties> usedRepositories = new HashSet<VcsRepositoryProperties>();
        for (CheckoutItemProperties checkoutItem : checkoutTaskProperties.getCheckoutItems()) {
            PlanProperties planProperties;
            Optional<VcsRepositoryProperties> planRepository = this.findReferencedRepositoryInPlan(checkoutItem, planProperties = (PlanProperties)taskValidationContext.getOwnerPlan().get());
            if (!planRepository.isPresent()) {
                problems.add(new ValidationProblem(VALIDATION_CONTEXT.with("Checkout item"), "Repository: " + checkoutItem.getRepository() + " cannot be found in plan. Plan repositories: " + this.getAvailablePlanRepositories(planProperties)));
                continue;
            }
            if (!this.userHasReadPermissionToRepository(planRepository.get())) {
                problems.add(new ValidationProblem(VALIDATION_CONTEXT.with("Checkout item"), "Don't have READ permission to repository '%s'", new Object[]{planRepository.get().getParentName()}));
            }
            if (checkoutItem.isDefaultRepository()) {
                if (defaultRepositoryAlreadyReferenced) {
                    problems.add(new ValidationProblem(VALIDATION_CONTEXT.with("Checkout item"), "Repository " + checkoutItem.getRepository() + " used more than once"));
                }
                defaultRepositoryAlreadyReferenced = true;
                continue;
            }
            if (usedRepositories.add(planRepository.get())) continue;
            problems.add(new ValidationProblem(VALIDATION_CONTEXT.with("Checkout item"), "Repository " + checkoutItem.getRepository() + " used more than once"));
        }
    }

    private String getAvailablePlanRepositories(PlanProperties planProperties) {
        return planProperties.getRepositories().stream().map(PlanRepositoryLinkProperties::getRepositoryDefinition).map(this::extractRepositoryName).filter(Objects::nonNull).collect(Collectors.joining(", "));
    }

    @Nullable
    private VcsRepositoryData findRepository(VcsRepositoryProperties repositoryProperties) {
        if (StringUtils.isNotEmpty((CharSequence)repositoryProperties.getName())) {
            return this.findReferencedLinkedRepositoryByName(repositoryProperties.getName()).orElse(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)repositoryProperties.getParentName())) {
            return this.findReferencedLinkedRepositoryByName(repositoryProperties.getParentName()).orElse(null);
        }
        return null;
    }

    @Nullable
    private String extractRepositoryName(VcsRepositoryProperties repository) {
        if (StringUtils.isEmpty((CharSequence)repository.getParent())) {
            return repository.getName();
        }
        VcsRepositoryData vcsRepositoryData = this.findRepository(repository);
        if (vcsRepositoryData != null && this.userHasReadPermissionToRepository(vcsRepositoryData)) {
            return repository.getParentName();
        }
        return null;
    }

    private boolean userHasReadPermissionToRepository(@NotNull VcsRepositoryProperties vcsRepositoryProperties) {
        return this.findReferencedLinkedRepositoryByName(vcsRepositoryProperties.getParentName()).map(this::userHasReadPermissionToRepository).orElse(true);
    }

    private boolean userHasReadPermissionToRepository(@NotNull VcsRepositoryData repositoryData) {
        return this.permissionManager.hasPermission((Permission)BambooPermission.READ, (Object)repositoryData, null);
    }

    private Optional<VcsRepositoryProperties> findReferencedRepositoryInPlan(CheckoutItemProperties checkoutItem, PlanProperties planProperties) {
        if (checkoutItem.isDefaultRepository()) {
            return Optional.ofNullable(Iterables.getFirst((Iterable)planProperties.getRepositories(), null)).map(PlanRepositoryLinkProperties::getRepositoryDefinition);
        }
        return RepositoryReferenceHelper.findReferencedRepositoryInPlan((VcsRepositoryIdentifierProperties)checkoutItem.getRepository(), (PlanProperties)planProperties);
    }
}

