/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.vcs.task.export;

import com.atlassian.bamboo.plugins.vcs.task.configuration.VcsBranchTaskConfigurator;
import com.atlassian.bamboo.plugins.vcs.task.export.AbstractVcsTaskExporter;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.task.VcsBranchTask;
import com.atlassian.bamboo.specs.model.task.VcsBranchTaskProperties;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VcsBranchTaskExporter
extends AbstractVcsTaskExporter {
    private static final ValidationContext VALIDATION_CONTEXT = ValidationContext.of((String)"VCS Branch Task");

    @Override
    @NotNull
    protected ValidationContext getValidationContext() {
        return VALIDATION_CONTEXT;
    }

    @Override
    protected boolean isRepositoryTypeSupported(@NotNull VcsRepositoryModuleDescriptor moduleDescriptor) {
        return new VcsBranchTaskConfigurator().isRepositoryModuleSupported(moduleDescriptor);
    }

    @NotNull
    public Map<String, String> toTaskConfiguration(@NotNull TaskContainer taskContainer, @NotNull TaskProperties taskProperties) {
        Map<String, String> configuration = this.baseVcsTaskToConfiguration(taskContainer, taskProperties);
        VcsBranchTaskProperties typedTaskProperties = this.getTypedTaskProperties(taskProperties, VcsBranchTaskProperties.class);
        configuration.put("branchName", typedTaskProperties.getBranchName());
        return configuration;
    }

    @NotNull
    public VcsBranchTask toSpecsEntity(@NotNull TaskDefinition taskDefinition) {
        Map configuration = taskDefinition.getConfiguration();
        return this.baseVcsTaskToSpecsEntity(taskDefinition, new VcsBranchTask()).branchName((String)configuration.get("branchName"));
    }

    @NotNull
    public List<ValidationProblem> validate(@NotNull TaskValidationContext taskValidationContext, @NotNull TaskProperties taskProperties) {
        return this.baseVcsTaskValidate(taskValidationContext, taskProperties);
    }
}

