/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.vcs.task.export;

import com.atlassian.bamboo.configuration.external.helpers.RepositoryReferenceHelper;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.plugin.PluginKeyProvider;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.repository.VcsRepositoryIdentifier;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.task.BaseVcsTask;
import com.atlassian.bamboo.specs.model.task.BaseVcsTaskProperties;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.export.AbstractRepositoryAwareTaskExporter;
import com.atlassian.bamboo.task.export.TaskDefinitionExporter;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import com.atlassian.bamboo.task.repository.RepositoryTaskHelper;
import com.atlassian.bamboo.utils.OptionalNarrow;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractVcsTaskExporter
extends AbstractRepositoryAwareTaskExporter
implements TaskDefinitionExporter {
    @Autowired
    protected VcsRepositoryManager vcsRepositoryManager;

    @NotNull
    protected abstract ValidationContext getValidationContext();

    protected abstract boolean isRepositoryTypeSupported(@NotNull VcsRepositoryModuleDescriptor var1);

    protected boolean isDefaultRepositoryRef(@NotNull String repositorySelector, @NotNull Map<String, String> configuration) {
        return this.isDefaultRepositoryRef(configuration.get(repositorySelector));
    }

    @NotNull
    protected Map<String, String> baseVcsTaskToConfiguration(@NotNull TaskContainer taskContainer, @NotNull TaskProperties taskProperties) {
        HashMap<String, String> configuration = new HashMap<String, String>();
        BaseVcsTaskProperties typedTaskProperties = this.getTypedTaskProperties(taskProperties, BaseVcsTaskProperties.class);
        if (typedTaskProperties.isDefaultRepository()) {
            configuration.put(RepositoryTaskHelper.CFG_SELECTED_REPOSITORY, RepositoryTaskHelper.CFG_DEFAULT_REPOSITORY);
        } else {
            VcsRepositoryIdentifierProperties repositoryIdentifier = (VcsRepositoryIdentifierProperties)Preconditions.checkNotNull((Object)typedTaskProperties.getRepository());
            configuration.put(RepositoryTaskHelper.CFG_SELECTED_REPOSITORY, this.getRepositoryIdString(repositoryIdentifier, taskContainer));
        }
        if (typedTaskProperties.getWorkingSubdirectory() != null) {
            configuration.put("workingSubDirectory", typedTaskProperties.getWorkingSubdirectory());
        }
        return configuration;
    }

    @NotNull
    protected <P extends BaseVcsTaskProperties, B extends BaseVcsTask<B, P>> B baseVcsTaskToSpecsEntity(@NotNull TaskDefinition taskDefinition, @NotNull B specsEntity) {
        Map configuration = taskDefinition.getConfiguration();
        String selectedRepository = (String)configuration.get(RepositoryTaskHelper.CFG_SELECTED_REPOSITORY);
        if (RepositoryTaskHelper.CFG_DEFAULT_REPOSITORY.equals(selectedRepository)) {
            specsEntity.defaultRepository();
        } else {
            specsEntity.repository(this.getNonDefaultRepositoryRef(selectedRepository));
        }
        if (configuration.containsKey("workingSubDirectory")) {
            specsEntity.workingSubdirectory((String)configuration.get("workingSubDirectory"));
        }
        return specsEntity;
    }

    @NotNull
    protected List<ValidationProblem> baseVcsTaskValidate(@NotNull TaskValidationContext taskValidationContext, @NotNull TaskProperties taskProperties) {
        VcsRepositoryIdentifierProperties repositoryIdentifier;
        String workingSubdirectory;
        ArrayList<ValidationProblem> validationProblems = new ArrayList<ValidationProblem>();
        BaseVcsTaskProperties typedTaskProperties = this.getTypedTaskProperties(taskProperties, BaseVcsTaskProperties.class);
        boolean defaultRepository = typedTaskProperties.isDefaultRepository();
        if (defaultRepository) {
            if (taskValidationContext.getOwnerDeployment().isPresent()) {
                validationProblems.add(new ValidationProblem(this.getValidationContext().with("default repository"), "Default repository can only be selected when the task is added to a plan. This option is not available for deployments."));
            } else {
                PlanProperties plan = (PlanProperties)taskValidationContext.getOwnerPlan().get();
                if (plan.getRepositories().isEmpty()) {
                    validationProblems.add(new ValidationProblem(this.getValidationContext().with("default repository"), "Can't select the default repository, because there are no repositories defined for the plan."));
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(workingSubdirectory = typedTaskProperties.getWorkingSubdirectory())) && taskValidationContext.getOwnerPlan().isPresent()) {
            validationProblems.add(new ValidationProblem(this.getValidationContext().with("working subdirectory"), "Working subdirectory can only be selected when the task is added to a deployment. This option is not available for plans."));
        }
        if (!defaultRepository && (repositoryIdentifier = (VcsRepositoryIdentifierProperties)Preconditions.checkNotNull((Object)typedTaskProperties.getRepository())) == null) {
            validationProblems.add(new ValidationProblem(this.getValidationContext().with("repository"), "Either the default repository or a specific repository must be selected for this task."));
        }
        if (validationProblems.isEmpty()) {
            Optional<String> repositoryPluginKey = this.getRepositoryPluginKey(taskValidationContext, typedTaskProperties);
            if (!repositoryPluginKey.isPresent()) {
                validationProblems.add(new ValidationProblem(this.getValidationContext().with("repository"), "Could not find repository referenced by this task: " + typedTaskProperties.getRepository()));
            } else {
                VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryPluginKey.get());
                if (moduleDescriptor == null) {
                    validationProblems.add(new ValidationProblem(this.getValidationContext().with("repository"), "Type of repository referenced by this task is unknown. Please make sure the necessary plugin is installed and enabled."));
                } else if (!this.isRepositoryTypeSupported(moduleDescriptor)) {
                    validationProblems.add(new ValidationProblem(this.getValidationContext().with("repository"), "Selected repository is not supported by this task."));
                }
            }
        }
        return validationProblems;
    }

    @NotNull
    protected <T> T getTypedTaskProperties(@NotNull TaskProperties taskProperties, @NotNull Class<T> expectedClass) {
        return OptionalNarrow.downTo((Object)taskProperties, expectedClass).orElseThrow(() -> new IllegalStateException(String.format("Unknown type of task properties, expected %s, actual %s", expectedClass.getName(), taskProperties.getClass().getName())));
    }

    @NotNull
    private Optional<String> getRepositoryPluginKey(@NotNull TaskValidationContext taskValidationContext, @NotNull BaseVcsTaskProperties baseVcsTaskProperties) {
        VcsRepositoryIdentifierProperties repository = baseVcsTaskProperties.getRepository();
        if (taskValidationContext.getOwnerPlan().isPresent()) {
            PlanProperties ownerPlan = (PlanProperties)taskValidationContext.getOwnerPlan().get();
            if (baseVcsTaskProperties.isDefaultRepository()) {
                Optional defaultRepo = RepositoryReferenceHelper.getDefaultRepositoryInPlan((PlanProperties)ownerPlan);
                return defaultRepo.flatMap(this::getRepositoryPluginKey);
            }
            Preconditions.checkState((repository != null ? 1 : 0) != 0);
            Optional planRepo = RepositoryReferenceHelper.findReferencedRepositoryInPlan((VcsRepositoryIdentifierProperties)repository, (PlanProperties)ownerPlan);
            return planRepo.flatMap(this::getRepositoryPluginKey);
        }
        Preconditions.checkState((repository != null ? 1 : 0) != 0);
        return this.getLinkedRepositoryPluginKey(repository);
    }

    @NotNull
    private Optional<String> getRepositoryPluginKey(@NotNull VcsRepositoryProperties repositoryProperties) {
        return Optional.of(repositoryProperties).map(VcsRepositoryProperties::getParent).map(this::getLinkedRepositoryPluginKey).orElseGet(() -> Optional.of(repositoryProperties).map(VcsRepositoryProperties::getAtlassianPlugin).map(AtlassianModuleProperties::getCompleteModuleKey));
    }

    @NotNull
    private Optional<String> getLinkedRepositoryPluginKey(@NotNull String name) {
        return this.getLinkedRepositoryPluginKey((VcsRepositoryIdentifierProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)new VcsRepositoryIdentifier(name)));
    }

    @NotNull
    private Optional<String> getLinkedRepositoryPluginKey(@NotNull VcsRepositoryIdentifierProperties repositoryIdentifier) {
        VcsRepositoryData repository = null;
        if (StringUtils.isNotEmpty((CharSequence)repositoryIdentifier.getName())) {
            repository = this.repositoryDefinitionManager.getLinkedRepositoryByName(repositoryIdentifier.getName());
        } else if (repositoryIdentifier.getOid() != null) {
            BambooEntityOid oid = BambooEntityOid.createFromExternalValue((String)repositoryIdentifier.getOid().getOid());
            repository = this.repositoryDefinitionManager.getVcsRepositoryDataByOid(oid);
        }
        return Optional.ofNullable(repository).map(PluginKeyProvider::getPluginKey);
    }
}

