/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.vcs.task.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.repository.AbstractRepositoryAwareTaskConfigurator;
import com.atlassian.bamboo.task.repository.RepositoryAwareTaskConfigurator;
import com.atlassian.bamboo.task.repository.RepositoryTaskHelper;
import com.atlassian.bamboo.util.BambooFilenameUtils;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.predicates.text.TextPredicates;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.runtime.FixedDirectoryWorkingCopyManager;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsCheckoutTaskConfigurator
extends AbstractRepositoryAwareTaskConfigurator
implements RepositoryAwareTaskConfigurator {
    private static final Logger log = Logger.getLogger(VcsCheckoutTaskConfigurator.class);
    public static final String CFG_SELECTED_REPOSITORIES_INDICES = "selectedRepositoriesIndices";
    public static final String CFG_SELECTED_REPOSITORY_ID_PREFIX = RepositoryTaskHelper.CFG_SELECTED_REPOSITORY_ID_PREFIX;
    public static final String CFG_DEFAULT_REPOSITORY = RepositoryTaskHelper.CFG_DEFAULT_REPOSITORY;
    public static final String CFG_CHECKOUT_DIR_PREFIX = RepositoryTaskHelper.CFG_CHECKOUT_DIR_PREFIX;
    public static final String CFG_CLEAN_CHECKOUT = "cleanCheckout";
    private static final String CTX_REPOSITORY_SELECTION = "repositories";
    private static final String CTX_CUSTOM_SOURCE_DIR_AWARE = "customWorkingDirectoryAwareRepositories";
    private static final String CTX_USING_LEGACY_SOURCE_DIRECTORY = "repositoriesUsingLegacySourceDirectory";

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        this.populateContextForAllOperations(context);
        context.putAll(taskDefinition.getConfiguration());
        this.generateSelectedRepositoriesList(context, taskDefinition);
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        this.populateContextForAllOperations(context);
        context.put(CFG_SELECTED_REPOSITORY_ID_PREFIX + "0", CFG_DEFAULT_REPOSITORY);
        context.put(CFG_SELECTED_REPOSITORIES_INDICES, Lists.newArrayList((Object[])new Integer[]{0}));
    }

    private void populateContextForAllOperations(@NotNull Map<String, Object> context) {
        LinkedHashMap<String, String> repositoryMap = new LinkedHashMap<String, String>();
        StringBuilder customSourceDirAwares = new StringBuilder();
        StringBuilder usingLegacySourceDirectory = new StringBuilder();
        if (context.containsKey("deploymentMode") && ((Boolean)context.get("deploymentMode")).booleanValue()) {
            for (VcsRepositoryData repositoryDefinition : this.repositoryDefinitionManager.getLinkedRepositories()) {
                VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryDefinition.getPluginKey());
                if (vcsRepositoryModuleDescriptor == null) continue;
                String idString = Long.toString(repositoryDefinition.getId());
                if (FixedDirectoryWorkingCopyManager.class.isAssignableFrom(vcsRepositoryModuleDescriptor.getModuleClass())) continue;
                customSourceDirAwares.append(idString);
                customSourceDirAwares.append(" ");
                repositoryMap.put(idString, repositoryDefinition.getName());
            }
            context.put(CTX_REPOSITORY_SELECTION, repositoryMap);
            context.put(CTX_CUSTOM_SOURCE_DIR_AWARE, customSourceDirAwares.toString());
            context.put(CTX_USING_LEGACY_SOURCE_DIRECTORY, usingLegacySourceDirectory.toString());
        } else {
            ImmutablePlan plan = (ImmutablePlan)context.get("plan");
            List repositoryDefinitions = PlanHelper.getPlanRepositoryDefinitions((ImmutablePlan)plan);
            boolean firstTime = true;
            for (PlanRepositoryDefinition repositoryDefinition : repositoryDefinitions) {
                VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryDefinition.getPluginKey());
                if (vcsRepositoryModuleDescriptor != null) {
                    String idString = Long.toString(repositoryDefinition.getId());
                    if (FixedDirectoryWorkingCopyManager.class.isAssignableFrom(vcsRepositoryModuleDescriptor.getModuleClass())) {
                        usingLegacySourceDirectory.append(idString);
                        usingLegacySourceDirectory.append(" ");
                        if (firstTime) {
                            usingLegacySourceDirectory.append(CFG_DEFAULT_REPOSITORY);
                            usingLegacySourceDirectory.append(" ");
                        }
                    } else {
                        customSourceDirAwares.append(idString);
                        customSourceDirAwares.append(" ");
                        if (firstTime) {
                            customSourceDirAwares.append(CFG_DEFAULT_REPOSITORY);
                            customSourceDirAwares.append(" ");
                        }
                    }
                    repositoryMap.put(idString, repositoryDefinition.getName());
                }
                firstTime = false;
            }
            context.put(CTX_REPOSITORY_SELECTION, repositoryMap);
            context.put("defaultRepositoryKey", CFG_DEFAULT_REPOSITORY);
            if (repositoryDefinitions.iterator().hasNext()) {
                context.put("defaultRepositoryName", ((PlanRepositoryDefinition)repositoryDefinitions.iterator().next()).getName());
            } else {
                context.put("defaultRepositoryName", this.textProvider.getText("repository.no.default"));
            }
            context.put(CTX_CUSTOM_SOURCE_DIR_AWARE, customSourceDirAwares.toString());
            context.put(CTX_USING_LEGACY_SOURCE_DIRECTORY, usingLegacySourceDirectory.toString());
        }
    }

    private void generateSelectedRepositoriesList(Map<String, Object> context, TaskDefinition taskDefinition) {
        List selectedRepositories = taskDefinition.getConfiguration().keySet().stream().filter(TextPredicates.startsWith((String)CFG_SELECTED_REPOSITORY_ID_PREFIX)).map(key -> StringUtils.removeStart((String)key, (String)CFG_SELECTED_REPOSITORY_ID_PREFIX)).map(Long::valueOf).collect(Collectors.toList());
        context.put(CFG_SELECTED_REPOSITORIES_INDICES, selectedRepositories);
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        for (String key : Iterables.filter((Iterable)params.keySet(), TextPredicates.startsWith((String)CFG_CHECKOUT_DIR_PREFIX)::test)) {
            String checkoutDir = params.getString(key);
            if (BambooFilenameUtils.doesPathFollowToParentDirectory((String)checkoutDir)) {
                errorCollection.addError(key, this.textProvider.getText("vcs.checkout.directory.parent.forbidden"));
            }
            if (!BambooFilenameUtils.isPathAbsolute((String)checkoutDir)) continue;
            errorCollection.addError(key, this.textProvider.getText("vcs.checkout.directory.absolute.forbidden"));
        }
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(CFG_CLEAN_CHECKOUT, params.getString(CFG_CLEAN_CHECKOUT));
        for (String key : params.keySet()) {
            if (!key.startsWith(CFG_SELECTED_REPOSITORY_ID_PREFIX) && !key.startsWith(CFG_CHECKOUT_DIR_PREFIX)) continue;
            config.put(key, params.getString(key));
        }
        return config;
    }
}

