/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.vcs.task.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.task.TaskContextHelper;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.repository.AbstractRepositoryAwareTaskConfigurator;
import com.atlassian.bamboo.task.repository.RepositoryAwareTaskConfigurator;
import com.atlassian.bamboo.task.repository.RepositoryTaskHelper;
import com.atlassian.bamboo.utils.NameProvider;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractVcsTaskConfigurator
extends AbstractRepositoryAwareTaskConfigurator
implements RepositoryAwareTaskConfigurator {
    public static final String CFG_AVAILABLE_REPOSITORIES = "availableRepositories";
    public static final String CFG_SUPPORTED_REPOSITORIES = "supportedRepositories";
    public static final String CFG_DEFAULT_REPOSITORY_KEY = "defaultRepositoryKey";
    public static final String CFG_DEFAULT_REPOSITORY_NAME = "defaultRepositoryName";
    private static final List<String> FIELDS_TO_COPY = ImmutableList.of((Object)"workingSubDirectory", (Object)RepositoryTaskHelper.CFG_SELECTED_REPOSITORY);

    protected abstract boolean isRepositoryModuleSupported(@NotNull VcsRepositoryModuleDescriptor var1);

    @NotNull
    protected abstract List<String> getAdditionalFieldsToCopy();

    @NotNull
    protected abstract Map<String, Object> getDefaultFieldValues();

    protected abstract void additionalValidate(@NotNull ActionParametersMap var1, @NotNull ErrorCollection var2);

    public final void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        this.populateContext(context);
        this.taskConfiguratorHelper.populateContextWithConfiguration(context, taskDefinition, this.getFieldsToCopy());
    }

    public final void populateContextForCreate(@NotNull Map<String, Object> context) {
        this.populateContext(context);
        this.getDefaultFieldValues().forEach(context::put);
    }

    public final void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        if (!params.containsKey((Object)RepositoryTaskHelper.CFG_SELECTED_REPOSITORY)) {
            errorCollection.addErrorMessage(this.getI18nBean().getText("vcs.common.error.no.repository.selected"));
        }
        this.additionalValidate(params, errorCollection);
    }

    @NotNull
    public final Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        HashMap<String, String> config = new HashMap<String, String>();
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(config, params, this.getFieldsToCopy());
        return config;
    }

    private void populateContext(@NotNull Map<String, Object> context) {
        boolean allowDefaultRepository;
        Map<Long, String> availableRepositories = this.getAvailableRepositories(context);
        Optional<PlanRepositoryDefinition> defaultRepository = this.getDefaultRepository(context);
        boolean bl = allowDefaultRepository = defaultRepository.isPresent() && availableRepositories.keySet().contains(defaultRepository.get().getId());
        if (allowDefaultRepository) {
            context.put(CFG_DEFAULT_REPOSITORY_KEY, RepositoryTaskHelper.CFG_DEFAULT_REPOSITORY);
            context.put(CFG_DEFAULT_REPOSITORY_NAME, defaultRepository.map(NameProvider::getName).orElse(""));
        }
        context.put(CFG_AVAILABLE_REPOSITORIES, availableRepositories);
        context.put(CFG_SUPPORTED_REPOSITORIES, this.getSupportedRepositories());
    }

    @NotNull
    private Optional<PlanRepositoryDefinition> getDefaultRepository(@NotNull Map<String, Object> context) {
        return TaskContextHelper.isDeploymentMode(context) ? Optional.empty() : Optional.ofNullable(PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)((ImmutablePlan)context.get("plan"))));
    }

    @NotNull
    private Map<Long, String> getAvailableRepositories(@NotNull Map<String, Object> context) {
        LinkedHashMap<Long, String> result = new LinkedHashMap<Long, String>();
        List repositoryDefinitions = TaskContextHelper.isDeploymentMode(context) ? this.repositoryDefinitionManager.getLinkedRepositories() : PlanHelper.getPlanRepositoryDefinitions((ImmutablePlan)((ImmutablePlan)context.get("plan")));
        repositoryDefinitions.stream().filter(this::isRepositorySupported).forEach(repository -> result.put(repository.getId(), repository.getName()));
        return result;
    }

    @NotNull
    private List<String> getSupportedRepositories() {
        return this.vcsRepositoryManager.getAvailableRepositoryDescriptors().stream().filter(this::isRepositoryModuleSupported).map(NameProvider::getName).collect(Collectors.toList());
    }

    private boolean isRepositorySupported(@NotNull VcsRepositoryData vcsRepositoryData) {
        String repositoryPluginKey = vcsRepositoryData.getPluginKey();
        VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryPluginKey);
        return moduleDescriptor != null && this.isRepositoryModuleSupported(moduleDescriptor);
    }

    @NotNull
    private List<String> getFieldsToCopy() {
        return ImmutableList.copyOf((Collection)ImmutableSet.builder().addAll(FIELDS_TO_COPY).addAll(this.getAdditionalFieldsToCopy()).build());
    }
}

