/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.vcs.task;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.plugins.vcs.task.utils.VcsTaskUtils;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.repository.RepositoryTaskHelper;
import com.atlassian.bamboo.utils.BambooPreconditions;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildContextHelper;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.runtime.StatusProvidingVcsWorkingCopyManager;
import com.atlassian.bamboo.vcs.runtime.VcsWorkingCopy;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class VcsTagTask
implements CommonTaskType {
    @Autowired
    private VcsRepositoryManager vcsRepositoryManager;

    @NotNull
    public TaskResult execute(@NotNull CommonTaskContext taskContext) throws TaskException {
        CommonContext commonContext = taskContext.getCommonContext();
        TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        ConfigurationMap configurationMap = taskContext.getConfigurationMap();
        BuildLogger buildLogger = taskContext.getBuildLogger();
        String repositoryIdString = (String)configurationMap.get((Object)RepositoryTaskHelper.CFG_SELECTED_REPOSITORY);
        BambooPreconditions.checkThat((boolean)StringUtils.isNotEmpty((CharSequence)repositoryIdString), TaskException::new, (String)"No repository was selected", (Object[])new Object[0]);
        long repositoryId = repositoryIdString.equals(RepositoryTaskHelper.CFG_DEFAULT_REPOSITORY) ? BuildContextHelper.getDefaultPlanRepositoryDefinition((BuildContext)((BuildContext)commonContext)).getId() : Long.parseLong(repositoryIdString);
        PlanRepositoryDefinition repositoryDefinition = (PlanRepositoryDefinition)commonContext.getVcsRepositoryMap().get(repositoryId);
        BambooPreconditions.checkThat((repositoryDefinition != null ? 1 : 0) != 0, TaskException::new, (String)"Repository id %d is invalid. Please reselect from the configuration screen.", (Object[])new Object[]{repositoryId});
        String repositoryPluginKey = repositoryDefinition.getPluginKey();
        VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryPluginKey);
        BambooPreconditions.checkThat((moduleDescriptor != null ? 1 : 0) != 0, TaskException::new, (String)"Repository plugin is not available: %s", (Object[])new Object[]{repositoryPluginKey});
        BambooPreconditions.checkThat((boolean)moduleDescriptor.supportsTagCreation(), TaskException::new, (String)"Repository '%s' does not support tagging ", (Object[])new Object[]{repositoryDefinition.getName()});
        BambooPreconditions.checkThat((boolean)moduleDescriptor.providesWorkingCopyStatus(), TaskException::new, (String)"Repository '%s' does not provide working copy status", (Object[])new Object[]{repositoryDefinition.getName()});
        try {
            String tagName = (String)taskContext.getConfigurationMap().get((Object)"tagName");
            File checkoutLocation = VcsTaskUtils.getCheckoutDirectory(taskContext, repositoryId);
            VcsWorkingCopy workingCopyInfo = ((StatusProvidingVcsWorkingCopyManager)moduleDescriptor.getWorkingCopyManager()).getWorkingCopyInfo((VcsRepositoryData)repositoryDefinition, checkoutLocation);
            String vcsRevisionKey = workingCopyInfo.getCurrentRevisionKey();
            moduleDescriptor.getTagCreator().createTag((VcsRepositoryData)repositoryDefinition, tagName, vcsRevisionKey, checkoutLocation.getAbsolutePath(), buildLogger);
            return taskResultBuilder.build();
        }
        catch (Exception e) {
            throw new TaskException("An error occurred while tagging a repository", (Throwable)e);
        }
    }
}

