/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.vcs.task;

import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.plugins.vcs.task.utils.VcsTaskUtils;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.repository.RepositoryTaskHelper;
import com.atlassian.bamboo.utils.BambooPreconditions;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildContextHelper;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.runtime.StatusProvidingVcsWorkingCopyManager;
import com.atlassian.bamboo.vcs.runtime.UpdatingVcsWorkingCopyManager;
import com.atlassian.bamboo.vcs.runtime.VcsWorkingCopy;
import com.atlassian.bamboo.vcs.runtime.VcsWorkingCopyManager;
import java.io.File;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class VcsPushTask
implements CommonTaskType {
    @Inject
    private VcsRepositoryManager vcsRepositoryManager;

    @NotNull
    public TaskResult execute(@NotNull CommonTaskContext commonTaskContext) throws TaskException {
        CommonContext commonContext = commonTaskContext.getCommonContext();
        ConfigurationMap configurationMap = commonTaskContext.getConfigurationMap();
        TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)commonTaskContext);
        String repositoryIdString = (String)configurationMap.get((Object)RepositoryTaskHelper.CFG_SELECTED_REPOSITORY);
        BambooPreconditions.checkThat((boolean)StringUtils.isNotEmpty((CharSequence)repositoryIdString), TaskException::new, (String)"No repository was selected", (Object[])new Object[0]);
        long repositoryId = repositoryIdString.equals(RepositoryTaskHelper.CFG_DEFAULT_REPOSITORY) ? BuildContextHelper.getDefaultPlanRepositoryDefinition((BuildContext)((BuildContext)commonContext)).getId() : Long.parseLong(repositoryIdString);
        PlanRepositoryDefinition repositoryDefinition = (PlanRepositoryDefinition)commonContext.getVcsRepositoryMap().get(repositoryId);
        BambooPreconditions.checkThat((repositoryDefinition != null ? 1 : 0) != 0, TaskException::new, (String)"Repository id %d is invalid. Please reselect from the configuration screen.", (Object[])new Object[]{repositoryId});
        String repositoryPluginKey = repositoryDefinition.getPluginKey();
        VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryPluginKey);
        BambooPreconditions.checkThat((moduleDescriptor != null ? 1 : 0) != 0, TaskException::new, (String)"Repository plugin is not available: %s", (Object[])new Object[]{repositoryPluginKey});
        BambooPreconditions.checkThat((boolean)moduleDescriptor.supportsRemoteUpdates(), TaskException::new, (String)"Repository '%s' does not support remote updates", (Object[])new Object[]{repositoryDefinition.getName()});
        BambooPreconditions.checkThat((boolean)moduleDescriptor.isDistributedVcs(), TaskException::new, (String)"Repository '%s' is not of DVCS type", (Object[])new Object[]{repositoryDefinition.getName()});
        BambooPreconditions.checkThat((boolean)moduleDescriptor.providesWorkingCopyStatus(), TaskException::new, (String)"Repository '%s' does not provide working copy status", (Object[])new Object[]{repositoryDefinition.getName()});
        try {
            File checkoutLocation = VcsTaskUtils.getCheckoutDirectory(commonTaskContext, repositoryId);
            VcsWorkingCopyManager workingCopyManager = moduleDescriptor.getWorkingCopyManager();
            UpdatingVcsWorkingCopyManager updatingWorkingCopyManager = (UpdatingVcsWorkingCopyManager)workingCopyManager;
            StatusProvidingVcsWorkingCopyManager statusProvidingWorkingCopyManager = (StatusProvidingVcsWorkingCopyManager)workingCopyManager;
            VcsWorkingCopy workingCopyInfo = statusProvidingWorkingCopyManager.getWorkingCopyInfo((VcsRepositoryData)repositoryDefinition, checkoutLocation);
            VcsWorkingCopy vcsWorkingCopy = updatingWorkingCopyManager.updateRemote(workingCopyInfo, (VcsRepositoryData)repositoryDefinition, "");
            if (!vcsWorkingCopy.isCurrentBranchChanged()) {
                VcsTaskUtils.appendAffectedCommits(repositoryId, vcsWorkingCopy.getCurrentRevisionKey(), commonTaskContext);
            }
            return taskResultBuilder.build();
        }
        catch (Exception e) {
            throw new TaskException("An error occurred while pushing changes to remote repository", (Throwable)e);
        }
    }
}

