/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.vcs.task;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.deployments.execution.DeploymentTaskContext;
import com.atlassian.bamboo.executor.CancelException;
import com.atlassian.bamboo.executor.RetryingTaskExecutor;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.branch.MergeResult;
import com.atlassian.bamboo.plan.branch.VcsBranchIntegrationHelper;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionData;
import com.atlassian.bamboo.plugins.vcs.task.configuration.VcsCheckoutTaskConfigurator;
import com.atlassian.bamboo.repository.RepositoryDefinitionException;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.PreparationTask;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.repository.RepositoryTaskHelper;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.trigger.DefaultChangeDetectionManager;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.runtime.FixedDirectoryWorkingCopyManager;
import com.atlassian.bamboo.vcs.runtime.MergingVcsWorkingCopyManager;
import com.atlassian.bamboo.vcs.runtime.VcsWorkingCopy;
import com.atlassian.bamboo.vcs.runtime.VcsWorkingCopyManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import io.atlassian.fugue.Pair;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsCheckoutTask
implements CommonTaskType,
PreparationTask {
    private static final Logger log = Logger.getLogger(VcsCheckoutTask.class);
    private static final int MAX_RETRIES = DefaultChangeDetectionManager.MAX_OPERATION_RETRIES;
    private VcsBranchIntegrationHelper branchIntegrationHelper;
    private VcsRepositoryManager vcsRepositoryManager;

    public VcsCheckoutTask(VcsBranchIntegrationHelper branchIntegrationHelper, VcsRepositoryManager vcsRepositoryManager) {
        this.branchIntegrationHelper = branchIntegrationHelper;
        this.vcsRepositoryManager = vcsRepositoryManager;
    }

    @NotNull
    public TaskResult execute(final @NotNull CommonTaskContext taskContext) throws TaskException {
        PlanRepositoryDefinition repositoryToCheckout;
        String checkoutDirectory;
        TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        boolean deploymentMode = taskContext instanceof DeploymentTaskContext;
        CommonContext commonContext = taskContext.getCommonContext();
        BuildLogger buildLogger = taskContext.getBuildLogger();
        boolean cleanCheckout = Boolean.parseBoolean((String)taskContext.getConfigurationMap().get((Object)"cleanCheckout"));
        ArrayList<Pair> repositoriesToCheckout = new ArrayList<Pair>();
        List selectors = taskContext.getConfigurationMap().keySet().stream().filter(arg_0 -> ((Predicate)RepositoryTaskHelper.isRepositorySelector).apply(arg_0)).sorted((Comparator<String>)RepositoryTaskHelper.orderingOfRepositorySelectors).collect(Collectors.toList());
        for (String key : selectors) {
            String indexString = key.substring(VcsCheckoutTaskConfigurator.CFG_SELECTED_REPOSITORY_ID_PREFIX.length());
            checkoutDirectory = (String)taskContext.getConfigurationMap().get((Object)(VcsCheckoutTaskConfigurator.CFG_CHECKOUT_DIR_PREFIX + indexString));
            try {
                PlanRepositoryDefinition repositoryToCheckout2 = RepositoryTaskHelper.getPlanRepositoryByIdSelector((CommonTaskContext)taskContext, (String)key);
                repositoriesToCheckout.add(Pair.pair((Object)repositoryToCheckout2, (Object)checkoutDirectory));
            }
            catch (RepositoryDefinitionException e) {
                throw new TaskException("Error while updating source", (Throwable)e);
            }
        }
        for (Pair pair : repositoriesToCheckout) {
            repositoryToCheckout = (PlanRepositoryDefinition)pair.left();
            checkoutDirectory = (String)pair.right();
            VcsRepositoryModuleDescriptor moduleDescriptor = this.getModuleDescriptor(repositoryToCheckout);
            this.preRetrieveSourceCode(taskContext, commonContext, buildLogger, repositoryToCheckout, moduleDescriptor, checkoutDirectory, cleanCheckout);
        }
        for (Pair pair : repositoriesToCheckout) {
            repositoryToCheckout = (PlanRepositoryDefinition)pair.left();
            checkoutDirectory = (String)pair.right();
            File sourceDirectory = this.getCheckoutDirectory(taskContext, checkoutDirectory);
            buildLogger.addBuildLogEntry("Checking out into " + sourceDirectory);
            final VcsRepositoryModuleDescriptor moduleDescriptor = this.getModuleDescriptor(repositoryToCheckout);
            try {
                this.fillWorkingDirFromVcs(repositoryToCheckout, moduleDescriptor, PlanHelper.isDefault((PlanRepositoryDefinition)repositoryToCheckout), checkoutDirectory, taskContext);
            }
            catch (CancelException e) {
                throw e;
            }
            catch (Exception e) {
                RetryingTaskExecutor.retry((String)("Retrieving source for " + commonContext.getDisplayName()), (int)MAX_RETRIES, (Duration)RetryingTaskExecutor.randomInitialDelay(), (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        VcsCheckoutTask.this.fillWorkingDirFromVcs(repositoryToCheckout, moduleDescriptor, PlanHelper.isDefault((PlanRepositoryDefinition)repositoryToCheckout), checkoutDirectory, taskContext);
                        return null;
                    }
                });
            }
            if (deploymentMode) continue;
            BuildContext buildContext = (BuildContext)Narrow.downTo((Object)commonContext, BuildContext.class);
            buildContext.getCheckoutLocation().put(repositoryToCheckout.getId(), sourceDirectory.getAbsolutePath());
        }
        return taskResultBuilder.success().build();
    }

    private void preRetrieveSourceCode(final CommonTaskContext taskContext, CommonContext buildContext, BuildLogger buildLogger, final PlanRepositoryDefinition repositoryToCheckout, VcsRepositoryModuleDescriptor moduleDescriptor, final String checkoutDirectory, final boolean cleanCheckout) {
        File sourceDirectory = this.getCheckoutDirectory(taskContext, checkoutDirectory);
        final VcsWorkingCopyManager workingCopyManager = moduleDescriptor.getWorkingCopyManager();
        try {
            this.cleanWorkingDirIfNeeded(checkoutDirectory, repositoryToCheckout, workingCopyManager, taskContext, cleanCheckout);
        }
        catch (CancelException e) {
            throw e;
        }
        catch (Exception e) {
            RetryingTaskExecutor.retry((String)("Cleaning directory for " + taskContext.getCommonContext().getDisplayName()), (int)MAX_RETRIES, (Duration)RetryingTaskExecutor.randomInitialDelay(), (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    VcsCheckoutTask.this.cleanWorkingDirIfNeeded(checkoutDirectory, repositoryToCheckout, workingCopyManager, taskContext, cleanCheckout);
                    return null;
                }
            });
        }
    }

    private File getCheckoutDirectory(@NotNull CommonTaskContext taskContext, @NotNull String checkoutDir) {
        File sourceCodeDir = new File(taskContext.getRootDirectory(), checkoutDir);
        sourceCodeDir.mkdirs();
        return sourceCodeDir;
    }

    private void fillWorkingDirFromVcs(PlanRepositoryDefinition planRepositoryDefinition, VcsRepositoryModuleDescriptor moduleDescriptor, boolean isDefaultRepository, String checkoutDir, CommonTaskContext taskContext) throws RepositoryException {
        CommonContext commonContext = taskContext.getCommonContext();
        DeploymentTaskContext deploymentTaskContext = (DeploymentTaskContext)Narrow.to((Object)taskContext, DeploymentTaskContext.class);
        BuildLogger buildLogger = taskContext.getBuildLogger();
        VcsWorkingCopyManager workingCopyManager = moduleDescriptor.getWorkingCopyManager();
        if (deploymentTaskContext == null) {
            String vcsRevisionKey;
            boolean isBranchIntegrationEnabled;
            BuildContext buildContext = (BuildContext)Narrow.downTo((Object)commonContext, BuildContext.class);
            MergingVcsWorkingCopyManager merger = (MergingVcsWorkingCopyManager)Narrow.downTo((Object)workingCopyManager, MergingVcsWorkingCopyManager.class);
            boolean bl = isBranchIntegrationEnabled = isDefaultRepository && buildContext.getBuildDefinition().getBranchIntegrationConfiguration().isEnabled();
            if (isBranchIntegrationEnabled && merger == null) {
                throw new IllegalArgumentException("Branch integration enabled on a repository that does not support merging");
            }
            String targetRevision = buildContext.getBuildChanges().getVcsRevisionKey(planRepositoryDefinition.getId());
            if (isBranchIntegrationEnabled) {
                BuildLogger logger = taskContext.getBuildLogger();
                MergeResult mergeResult = this.branchIntegrationHelper.merge(buildContext, (VcsRepositoryData)planRepositoryDefinition, moduleDescriptor, this.branchIntegrationHelper.getIntegrationVcsBranch(buildContext), this.getCheckoutDirectory(taskContext, checkoutDir), logger);
                vcsRevisionKey = mergeResult.getCheckoutRevision();
            } else {
                PlanVcsRevisionData planVcsRevisionData = buildContext.getBuildChanges().getVcsRevisionData(planRepositoryDefinition.getId());
                log.info((Object)buildLogger.addBuildLogEntry("Updating source code to revision: " + targetRevision));
                VcsWorkingCopy workingCopy = workingCopyManager.retrieveSourceCode((CommonContext)buildContext, (VcsRepositoryData)planRepositoryDefinition, planVcsRevisionData, this.getCheckoutDirectory(taskContext, checkoutDir));
                vcsRevisionKey = workingCopy.getCurrentRevisionKey();
            }
            buildContext.getBuildChanges().setVcsRevisionKey(planRepositoryDefinition.getId(), vcsRevisionKey);
            buildContext.getBuildResult().setCheckoutSuccess(true);
            log.info((Object)buildLogger.addBuildLogEntry("Updated source code to revision: " + vcsRevisionKey));
        } else {
            log.info((Object)buildLogger.addBuildLogEntry("Updating source code to the latest revision"));
            VcsWorkingCopy workingCopy = workingCopyManager.updateToLatestRevision(commonContext, (VcsRepositoryData)planRepositoryDefinition, this.getCheckoutDirectory(taskContext, checkoutDir));
            log.info((Object)buildLogger.addBuildLogEntry("Updated source code to revision: " + workingCopy.getCurrentRevisionKey()));
        }
    }

    private void cleanWorkingDirIfNeeded(String checkoutDir, PlanRepositoryDefinition planRepositoryDefinition, VcsWorkingCopyManager workingCopyManager, CommonTaskContext taskContext, boolean cleanCheckout) throws RepositoryException {
        CommonContext commonContext = taskContext.getCommonContext();
        BuildLogger buildLogger = taskContext.getBuildLogger();
        String cleanBuildMessage = this.getCleanBuildMessage(cleanCheckout);
        if (cleanCheckout) {
            log.info((Object)buildLogger.addBuildLogEntry(cleanBuildMessage));
            Key entityKey = commonContext.getResultKey().getEntityKey();
            PlanKey planKey = PlanKeys.getPlanKey((String)entityKey.getKey());
            FixedDirectoryWorkingCopyManager fixedDirectoryWorkingCopyManager = (FixedDirectoryWorkingCopyManager)Narrow.to((Object)workingCopyManager, FixedDirectoryWorkingCopyManager.class);
            File planSourceDirectory = fixedDirectoryWorkingCopyManager != null ? fixedDirectoryWorkingCopyManager.getWorkingCopyPath(taskContext.getCommonContext(), (VcsRepositoryData)planRepositoryDefinition) : this.getCheckoutDirectory(taskContext, checkoutDir);
            log.info((Object)buildLogger.addBuildLogEntry("Cleaning build directory '" + planSourceDirectory.getAbsolutePath() + "'"));
            if (BambooFileUtils.isDirectoryImportant((File)planSourceDirectory)) {
                String errorMessage = "A clean build cannot be forced for " + planKey + ", as the plan's source directory " + planSourceDirectory.getAbsolutePath() + " is reserved by the system. Please amend your build configuration.";
                log.warn((Object)buildLogger.addErrorLogEntry(errorMessage));
                throw new RepositoryException(errorMessage);
            }
            if (planSourceDirectory.exists()) {
                try {
                    BambooFileUtils.cleanDirectory((File)planSourceDirectory);
                }
                catch (IOException e) {
                    String errorMessage = "Unable to clean source directory '" + planSourceDirectory.getAbsolutePath() + "' " + e.getMessage();
                    log.warn((Object)buildLogger.addErrorLogEntry(errorMessage), (Throwable)e);
                    throw new RepositoryException(errorMessage, (Throwable)e);
                }
            }
        }
    }

    @Nullable
    private String getCleanBuildMessage(boolean cleanCheckout) {
        if (cleanCheckout) {
            return "Build always requires a clean checkout";
        }
        return null;
    }

    private VcsRepositoryModuleDescriptor getModuleDescriptor(@NotNull PlanRepositoryDefinition planRepositoryDefinition) {
        return (VcsRepositoryModuleDescriptor)Preconditions.checkNotNull((Object)this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(planRepositoryDefinition.getPluginKey()), (Object)("Can't find change detector class for repository plugin " + planRepositoryDefinition.getPluginKey()));
    }
}

