/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.tomcat.upgrade;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildDefinitionManager;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.security.EncryptionService;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class PasswordUpgradeTask
implements PluginUpgradeTask {
    private final PlanManager planManager;
    private final BuildDefinitionManager buildDefinitionManager;
    private final EncryptionService encryptionService;
    public static final String TOMCAT_PLUGIN = "com.atlassian.bamboo.plugins.tomcat.bamboo-tomcat-plugin";

    public PasswordUpgradeTask(PlanManager planManager, BuildDefinitionManager buildDefinitionManager, EncryptionService encryptionService) {
        this.planManager = planManager;
        this.buildDefinitionManager = buildDefinitionManager;
        this.encryptionService = encryptionService;
    }

    public int getBuildNumber() {
        return 11;
    }

    public String getShortDescription() {
        return "Encrypt stored passwords for Tomcat server configuration";
    }

    public Collection<Message> doUpgrade() throws Exception {
        ArrayList messages = Lists.newArrayList();
        List plans = this.planManager.getAllPlansUnrestricted();
        for (TopLevelPlan plan : plans) {
            for (Job job : plan.getAllJobs()) {
                BuildDefinition buildDefinition = job.getBuildDefinition();
                for (TaskDefinition taskDefinition : buildDefinition.getTaskDefinitions()) {
                    this.encryptPassword(taskDefinition, "deployAppTask", messages);
                    this.encryptPassword(taskDefinition, "startAppTask", messages);
                    this.encryptPassword(taskDefinition, "stopAppTask", messages);
                    this.encryptPassword(taskDefinition, "reloadAppTask", messages);
                    this.encryptPassword(taskDefinition, "undeployAppTask", messages);
                }
                this.buildDefinitionManager.savePlanAndDefinition((Plan)job, buildDefinition);
            }
        }
        return messages;
    }

    private void encryptPassword(TaskDefinition taskDefinition, String taskKey, Collection<Message> messages) {
        Map config = taskDefinition.getConfiguration();
        if (taskDefinition.getPluginKey().equals("com.atlassian.bamboo.plugins.tomcat.bamboo-tomcat-plugin:" + taskKey)) {
            String password = (String)config.get("tomcatPassword");
            String encryptedPassword = (String)config.get("encTomcatPassword");
            if (StringUtils.isNotEmpty((String)password) && StringUtils.isEmpty((String)encryptedPassword)) {
                String newPassword = this.encryptionService.encrypt(password);
                config.put("encTomcatPassword", newPassword);
                config.remove("tomcatPassword");
                taskDefinition.setConfiguration(config);
            }
        }
    }

    public String getPluginKey() {
        return TOMCAT_PLUGIN;
    }
}

