/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.tomcat.tasks;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plugins.tomcat.manager.TaskTomcatConnection;
import com.atlassian.bamboo.plugins.tomcat.manager.TomcatApplicationManagerImpl;
import com.atlassian.bamboo.plugins.tomcat.manager.TomcatResult;
import com.atlassian.bamboo.security.EncryptionService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.variable.CustomVariableContext;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DeployAppTask
implements CommonTaskType {
    private static final Logger log = Logger.getLogger(DeployAppTask.class);
    private final EncryptionService encryptionService;
    private final CustomVariableContext customVariableContext;

    public DeployAppTask(EncryptionService encryptionService, CustomVariableContext customVariableContext) {
        this.encryptionService = encryptionService;
        this.customVariableContext = customVariableContext;
    }

    @NotNull
    public TaskResult execute(@NotNull CommonTaskContext taskContext) throws TaskException {
        TaskResultBuilder taskResultBuilder;
        block7: {
            BuildLogger buildLogger = taskContext.getBuildLogger();
            TaskTomcatConnection connection = new TaskTomcatConnection(taskContext, this.encryptionService);
            TomcatApplicationManagerImpl tomcatManager = new TomcatApplicationManagerImpl(connection, taskContext, this.customVariableContext, buildLogger);
            taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
            String context = (String)taskContext.getConfigurationMap().get((Object)"appContext");
            String version = (String)taskContext.getConfigurationMap().get((Object)"appVersion");
            String warFilePath = (String)taskContext.getConfigurationMap().get((Object)"warFilePath");
            String deploymentTag = (String)taskContext.getConfigurationMap().get((Object)"deploymentTag");
            File file = new File(taskContext.getRootDirectory(), warFilePath);
            if (file.isFile()) {
                try {
                    StringBuilder deployMessage = new StringBuilder().append("Deploying application with war file '").append(warFilePath).append("' to context '").append(context).append("' to server '").append(connection.getURL()).append("'");
                    if (StringUtils.isNotEmpty((String)version)) {
                        deployMessage.append(" with version '" + version + "'");
                    }
                    if (StringUtils.isNotEmpty((String)deploymentTag)) {
                        deployMessage.append(" with tag '" + deploymentTag + "'");
                    }
                    buildLogger.addBuildLogEntry(deployMessage.toString());
                    TomcatResult result = tomcatManager.deployApplication(context, version, deploymentTag, file);
                    if (result.isSuccessful()) {
                        buildLogger.addBuildLogEntry("Application was successfully deployed.");
                        taskResultBuilder.success();
                        break block7;
                    }
                    String message = "Application failed to deploy: " + result.getReason();
                    buildLogger.addErrorLogEntry(message);
                    taskResultBuilder.failed();
                }
                catch (IOException e) {
                    String log = "Could not deploy application: " + e.getMessage();
                    buildLogger.addErrorLogEntry(log, (Throwable)e);
                    taskResultBuilder.failedWithError();
                }
            } else {
                String noWarMessage = "Could not find war file at " + file.getAbsolutePath() + ". The application could not be deployed.";
                buildLogger.addErrorLogEntry(noWarMessage);
                taskResultBuilder.failedWithError();
            }
        }
        return taskResultBuilder.build();
    }
}

