/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.tomcat.manager;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plugins.tomcat.manager.Application;
import com.atlassian.bamboo.plugins.tomcat.manager.TomcatApplicationManager;
import com.atlassian.bamboo.plugins.tomcat.manager.TomcatConnection;
import com.atlassian.bamboo.plugins.tomcat.manager.TomcatResult;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TomcatApplicationManagerImpl
implements TomcatApplicationManager {
    private static final Logger log = Logger.getLogger(TomcatApplicationManagerImpl.class);
    private final String tomcatManagerUrl;
    private final HttpClient client;
    private boolean isTomcat6;
    private String confirmedTomcatVersion;
    @NotNull
    private final CustomVariableContext customVariableContext;
    @NotNull
    private final BuildLogger buildLogger;

    public TomcatApplicationManagerImpl(@NotNull TomcatConnection tomcatCredentials, @NotNull CommonTaskContext taskContext, @NotNull CustomVariableContext customVariableContext, @NotNull BuildLogger buildLogger) throws TaskException {
        this.customVariableContext = customVariableContext;
        this.buildLogger = buildLogger;
        try {
            this.tomcatManagerUrl = new URL(customVariableContext.substituteString(tomcatCredentials.getURL())).toString();
        }
        catch (MalformedURLException e) {
            throw new TaskException("Malformed Tomcat Manager URL, please fix your Tomcat Task configuration.", (Throwable)e);
        }
        HttpClientParams httpClientParams = new HttpClientParams();
        httpClientParams.setAuthenticationPreemptive(true);
        this.client = new HttpClient(httpClientParams);
        this.client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(customVariableContext.substituteString(tomcatCredentials.getUsername()), customVariableContext.substituteString(tomcatCredentials.getPassword())));
        this.isTomcat6 = taskContext.getConfigurationMap().getAsBoolean("tomcat6");
    }

    @Override
    @NotNull
    public List<Application> listApplications() throws IOException {
        ArrayList applications = Lists.newArrayList();
        String url = this.tomcatManagerUrl + this.getURLPrefix() + "/list";
        String result = this.execute((HttpMethod)new GetMethod(url));
        String[] lines = StringUtils.split((String)result, (char)'\n');
        if (lines.length > 1) {
            for (int i = 1; i < lines.length; ++i) {
                String[] appParts = StringUtils.split((String)lines[i], (String)":");
                applications.add(new Application(appParts[0], appParts[1], appParts[2], appParts[3]));
            }
        }
        return applications;
    }

    @Override
    public Application getApplicationByContext(final @NotNull String contextPath) throws IOException {
        return (Application)Iterables.find(this.listApplications(), (Predicate)new Predicate<Application>(){

            public boolean apply(Application application) {
                return contextPath.equals(application.getContext());
            }
        }, null);
    }

    @Override
    @NotNull
    public TomcatResult startApplication(@NotNull String contextPath) throws IOException {
        String url = this.tomcatManagerUrl + this.getURLPrefix() + "/start?path=" + TomcatApplicationManagerImpl.encode(this.customVariableContext.substituteString(contextPath));
        String result = this.execute((HttpMethod)new GetMethod(url));
        return TomcatResult.parse(result);
    }

    @Override
    @NotNull
    public TomcatResult reloadApplication(@NotNull String contextPath) throws IOException {
        String url = this.tomcatManagerUrl + this.getURLPrefix() + "/reload?path=" + TomcatApplicationManagerImpl.encode(this.customVariableContext.substituteString(contextPath));
        String result = this.execute((HttpMethod)new GetMethod(url));
        return TomcatResult.parse(result);
    }

    @Override
    @NotNull
    public TomcatResult stopApplication(@NotNull String contextPath) throws IOException {
        String url = this.tomcatManagerUrl + this.getURLPrefix() + "/stop?path=" + TomcatApplicationManagerImpl.encode(this.customVariableContext.substituteString(contextPath));
        String result = this.execute((HttpMethod)new GetMethod(url));
        return TomcatResult.parse(result);
    }

    @Override
    @NotNull
    public TomcatResult undeployApplication(@NotNull String contextPath) throws IOException {
        String url = this.tomcatManagerUrl + this.getURLPrefix() + "/undeploy?path=" + TomcatApplicationManagerImpl.encode(this.customVariableContext.substituteString(contextPath));
        String result = this.execute((HttpMethod)new GetMethod(url));
        return TomcatResult.parse(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public TomcatResult deployApplication(@NotNull String contextPath, @Nullable String version, @NotNull String deploymentTag, @NotNull File file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        try {
            StringBuilder urlBuilder = new StringBuilder(this.tomcatManagerUrl).append(this.getURLPrefix()).append("/deploy?path=").append(TomcatApplicationManagerImpl.encode(this.customVariableContext.substituteString(contextPath)));
            if (version != null) {
                urlBuilder.append("&version=").append(TomcatApplicationManagerImpl.encode(this.customVariableContext.substituteString(version)));
            }
            urlBuilder.append("&update=true&tag=").append(TomcatApplicationManagerImpl.encode(this.customVariableContext.substituteString(deploymentTag)));
            PutMethod putMethod = new PutMethod(urlBuilder.toString());
            putMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)inputStream, file.length()));
            putMethod.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(0, false));
            String result = this.execute((HttpMethod)putMethod);
            TomcatResult tomcatResult = TomcatResult.parse(result);
            return tomcatResult;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    @NotNull
    private String execute(HttpMethod httpMethod) throws IOException {
        try {
            this.addHeaders(httpMethod);
            this.client.executeMethod(httpMethod);
            int status = httpMethod.getStatusCode();
            if (TomcatApplicationManagerImpl.isSuccessfulCode(status)) {
                String string = httpMethod.getResponseBodyAsString();
                return string;
            }
            if (status == 403 || status == 401) {
                throw new IOException("Could not connect to Tomcat manager at '" + httpMethod.getURI() + "' because the username and password provided is not authorized. Status: " + status);
            }
            throw new IOException("Could not connect to Tomcat manager at '" + httpMethod.getURI() + "'. Response code: " + status);
        }
        finally {
            httpMethod.releaseConnection();
        }
    }

    private static boolean isSuccessfulCode(int status) {
        return status >= 200 && status < 300;
    }

    private void addHeaders(HttpMethod httpMethod) {
        httpMethod.setDoAuthentication(true);
        httpMethod.addRequestHeader("User-Agent", "Atlassian Tomcat API");
        httpMethod.getHostAuthState().isPreemptive();
    }

    private static String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private String getURLPrefix() {
        if (this.confirmedTomcatVersion == null) {
            this.confirmTomcatVersionThroughServerInfo();
        }
        return this.getURLPrefixByTomcatVersion(this.isTomcat6);
    }

    private void confirmTomcatVersionThroughServerInfo() {
        this.buildLogger.addBuildLogEntry("Confirm expected Tomcat manager location.");
        this.confirmedTomcatVersion = this.getTomcatVersionFromServerInfo(this.isTomcat6);
        if (this.confirmedTomcatVersion != null) {
            this.buildLogger.addBuildLogEntry("Confirmed Tomcat version: " + this.confirmedTomcatVersion);
        } else {
            this.buildLogger.addErrorLogEntry("Try likely variations of Tomcat manager location.");
            this.confirmedTomcatVersion = this.getTomcatVersionFromServerInfo(!this.isTomcat6);
            if (this.confirmedTomcatVersion != null) {
                if (this.isTomcat6) {
                    this.buildLogger.addErrorLogEntry("Detected that Tomcat version is wrongly specified as 6.x but is actually: " + this.confirmedTomcatVersion);
                } else {
                    this.buildLogger.addErrorLogEntry("Detected that Tomcat version is wrongly specified as 7.x or greater but is actually " + this.confirmedTomcatVersion);
                }
                this.isTomcat6 = !this.isTomcat6;
            } else {
                this.buildLogger.addErrorLogEntry("Could not detect Tomcat version from server info, trusting configuration of " + (this.isTomcat6 ? "Tomcat 6.x" : "Tomcat 7 or greater"));
            }
        }
    }

    private String getTomcatVersionFromServerInfo(boolean isExpectingTomcat6) {
        GetMethod getMethod = new GetMethod(this.tomcatManagerUrl + this.getURLPrefixByTomcatVersion(isExpectingTomcat6) + "/serverinfo");
        this.addHeaders((HttpMethod)getMethod);
        try {
            this.buildLogger.addBuildLogEntry("Trying to retrieve Tomcat details from " + getMethod.getURI());
            this.client.executeMethod((HttpMethod)getMethod);
        }
        catch (IOException e) {
            this.buildLogger.addErrorLogEntry("Could not list server info from " + getMethod.getPath(), (Throwable)e);
            return null;
        }
        if (!TomcatApplicationManagerImpl.isSuccessfulCode(getMethod.getStatusCode())) {
            this.buildLogger.addErrorLogEntry("Server info returned status code: " + getMethod.getStatusCode());
            return null;
        }
        String body = null;
        try {
            body = getMethod.getResponseBodyAsString();
        }
        catch (IOException e) {
            this.buildLogger.addErrorLogEntry("Error occurred trying to establish Tomcat version", (Throwable)e);
        }
        if (body == null) {
            this.buildLogger.addErrorLogEntry("Empty body occurred trying to establish Tomcat version");
            return null;
        }
        for (String line : StringUtils.split((String)body, (char)'\n')) {
            if (!line.startsWith("Tomcat Version: ")) continue;
            this.buildLogger.addBuildLogEntry("Found " + line);
            return line.substring("Tomcat Version: ".length());
        }
        this.buildLogger.addErrorLogEntry("Unable to find Tomcat Version in server info response: " + body);
        return null;
    }

    @NotNull
    private String getURLPrefixByTomcatVersion(boolean isTomcat6) {
        return isTomcat6 ? "" : "/text";
    }
}

