/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.tomcat.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.security.EncryptionService;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.opensymphony.xwork.TextProvider;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTomcatConfigurator
extends AbstractTaskConfigurator {
    private static final Logger log = Logger.getLogger(AbstractTomcatConfigurator.class);
    public static final String TOMCAT_URL = "tomcatUrl";
    public static final String TOMCAT_USERNAME = "tomcatUsername";
    public static final String TOMCAT_PLAIN_PASSWORD = "tomcatPassword";
    public static final String TOMCAT_PASSWORD = "encTomcatPassword";
    public static final String TOMCAT_6 = "tomcat6";
    public static final String APP_CONTEXT = "appContext";
    private static final Set<String> FIELDS_TO_COPY = ImmutableSet.builder().add((Object[])new String[]{"tomcatUrl", "tomcatUsername", "encTomcatPassword", "appContext", "tomcat6"}).build();
    private static final String PASSWORD_CHANGE = "passwordChange";
    protected TextProvider textProvider;
    private EncryptionService encryptionService;

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put(TOMCAT_URL, "http://localhost:8080/manager/");
        context.put(TOMCAT_USERNAME, "admin");
        context.put(APP_CONTEXT, "/test");
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.taskConfiguratorHelper.populateContextWithConfiguration(context, taskDefinition, Iterables.concat(FIELDS_TO_COPY, this.getFieldsToCopy()));
    }

    public void populateContextForView(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForView(context, taskDefinition);
        this.taskConfiguratorHelper.populateContextWithConfiguration(context, taskDefinition, Iterables.concat(FIELDS_TO_COPY, this.getFieldsToCopy()));
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        String url = params.getString(TOMCAT_URL);
        if (StringUtils.isEmpty((String)url)) {
            errorCollection.addError(TOMCAT_URL, this.textProvider.getText("tomcat.url.error"));
        }
        if (StringUtils.isEmpty((String)params.getString(TOMCAT_USERNAME))) {
            errorCollection.addError(TOMCAT_USERNAME, this.textProvider.getText("tomcat.username.error"));
        }
        if (StringUtils.isEmpty((String)params.getString(TOMCAT_PLAIN_PASSWORD)) && params.getBoolean(PASSWORD_CHANGE)) {
            errorCollection.addError(TOMCAT_PLAIN_PASSWORD, this.textProvider.getText("tomcat.password.error"));
        }
        if (StringUtils.isEmpty((String)params.getString(APP_CONTEXT))) {
            errorCollection.addError(APP_CONTEXT, this.textProvider.getText("tomcat.context.error"));
        }
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        String password;
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(config, params, Iterables.concat(FIELDS_TO_COPY, this.getFieldsToCopy()));
        String passwordChange = params.getString(PASSWORD_CHANGE);
        if ("true".equals(passwordChange)) {
            password = params.getString(TOMCAT_PLAIN_PASSWORD);
            config.put(TOMCAT_PASSWORD, this.encryptionService.encrypt(password));
        } else if (previousTaskDefinition != null) {
            config.put(TOMCAT_PASSWORD, previousTaskDefinition.getConfiguration().get(TOMCAT_PASSWORD));
        } else {
            password = params.getString(TOMCAT_PLAIN_PASSWORD);
            config.put(TOMCAT_PASSWORD, this.encryptionService.encrypt(password));
        }
        String tomcat6 = params.getString(TOMCAT_6);
        if ("true".equals(tomcat6)) {
            config.put(TOMCAT_6, Boolean.TRUE.toString());
        }
        return config;
    }

    protected abstract Set<String> getFieldsToCopy();

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    public void setEncryptionService(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }
}

