/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.tomcat.tasks;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plugins.tomcat.manager.TaskTomcatConnection;
import com.atlassian.bamboo.plugins.tomcat.manager.TomcatApplicationManagerImpl;
import com.atlassian.bamboo.plugins.tomcat.manager.TomcatResult;
import com.atlassian.bamboo.security.EncryptionService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.variable.CustomVariableContext;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class StopAppTask
implements CommonTaskType {
    private static final Logger log = Logger.getLogger(StopAppTask.class);
    private final EncryptionService encryptionService;
    private final CustomVariableContext customVariableContext;

    public StopAppTask(EncryptionService encryptionService, CustomVariableContext customVariableContext) {
        this.encryptionService = encryptionService;
        this.customVariableContext = customVariableContext;
    }

    @NotNull
    public TaskResult execute(@NotNull CommonTaskContext taskContext) throws TaskException {
        BuildLogger buildLogger = taskContext.getBuildLogger();
        TaskTomcatConnection connection = new TaskTomcatConnection(taskContext, this.encryptionService);
        TomcatApplicationManagerImpl tomcatManager = new TomcatApplicationManagerImpl(connection, taskContext, this.customVariableContext, buildLogger);
        TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        String context = (String)taskContext.getConfigurationMap().get((Object)"appContext");
        try {
            buildLogger.addBuildLogEntry("Stopping application at context '" + context + "' on server '" + connection.getURL() + "'");
            TomcatResult result = tomcatManager.stopApplication(context);
            if (result.isSuccessful()) {
                buildLogger.addBuildLogEntry("The application has been stopped");
                taskResultBuilder.success();
            } else {
                String message = "The application could not be stopped: " + result.getReason();
                buildLogger.addErrorLogEntry(message);
                taskResultBuilder.failed();
            }
        }
        catch (IOException e) {
            String log = "Could not stop application: " + e.getMessage();
            buildLogger.addErrorLogEntry(log);
            taskResultBuilder.failedWithError();
        }
        return taskResultBuilder.build();
    }
}

