/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.testresultparser.testng;

import com.atlassian.bamboo.plugins.testresultparser.testng.TestMethodEntity;
import com.atlassian.bamboo.plugins.testresultparser.testng.TestMethodExceptionEntity;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.atlassian.bamboo.utils.xml.BambooXmlUtils;
import com.atlassian.bamboo.utils.xml.SMInputCursorIterable;
import com.ctc.wstx.sw.BambooWstxInputFactory;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMEvent;
import org.codehaus.staxmate.in.SMFilter;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.in.SimpleFilter;
import org.jetbrains.annotations.NotNull;

@NotThreadSafe
public class TestNGResultsParser {
    private static final Logger log = Logger.getLogger(TestNGResultsParser.class);
    private static final ImmutableMap<String, TestState> STATUS_MAP = ImmutableMap.builder().put((Object)"PASS", (Object)TestState.SUCCESS).put((Object)"FAIL", (Object)TestState.FAILED).put((Object)"SKIP", (Object)TestState.SKIPPED).build();
    private static final String ATTR_TEST_METHOD_DURATION_MS = "duration-ms";
    private static final String ATTR_TEST_METHOD_IS_CONFIG = "is-config";
    private static final String ATTR_TEST_METHOD_NAME = "name";
    private static final String ATTR_TEST_METHOD_STATUS = "status";
    private static final String ATTR_TEST_METHOD_EXCEPTION_CLASS = "class";
    private static final String ELEM_ROOT = "testng-results";
    private static final String ELEM_TEST_METHOD = "test-method";
    private static final String ELEM_TEST_METHOD_EXCEPTION = "exception";
    private static final String ELEM_TEST_METHOD_EXCEPTION_MESSAGE = "message";
    private static final String ELEM_TEST_METHOD_EXCEPTION_STACKTRACE = "full-stacktrace";
    private static final String ELEM_TEST_METHOD_PARAM = "param";
    private static final String ELEM_TEST_METHOD_PARAM_VALUE = "value";
    private static final String ELEM_TEST_METHOD_PARAMS = "params";
    private static final String ELEM_TEST_METHOD_REPORTER_OUTPUT = "reporter-output";
    private static final String ELEM_TEST_METHOD_REPORTER_OUTPUT_LINE = "line";
    private List<TestResults> failedTests = new LinkedList<TestResults>();
    private List<TestResults> passedTests = new LinkedList<TestResults>();
    private List<TestResults> skippedTests = new LinkedList<TestResults>();
    private String suiteName;
    private String testName;
    private String className;

    public void parse(@NotNull InputStream inputStream) throws XMLStreamException {
        this.parse(new InputStreamReader(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(@NotNull Reader in) throws XMLStreamException {
        this.failedTests = new LinkedList<TestResults>();
        this.passedTests = new LinkedList<TestResults>();
        this.skippedTests = new LinkedList<TestResults>();
        SMInputFactory factory = new SMInputFactory(BambooXmlUtils.configure((XMLInputFactory)new BambooWstxInputFactory()));
        SMInputCursor rootCursor = factory.rootElementCursor(BambooXmlUtils.sanitiseXml10Reader((Reader)in)).advance();
        try {
            rootCursor.setElementTracking(SMInputCursor.Tracking.PARENTS);
            if (rootCursor.getCurrEvent() == SMEvent.START_ELEMENT) {
                if (ELEM_ROOT.equals(rootCursor.getLocalName())) {
                    for (SMInputCursor childCursor : SMInputCursorIterable.fromCursor((SMInputCursor)rootCursor.childElementCursor("suite"))) {
                        this.parseSuite(childCursor);
                    }
                } else {
                    log.info((Object)String.format("Unexpected root tag name %s instead of %s - ignoring input", rootCursor.getLocalName(), ELEM_ROOT));
                }
            } else {
                log.info((Object)"Unexpected XML parser state - ignoring input");
            }
        }
        finally {
            rootCursor.getStreamReader().closeCompletely();
        }
    }

    @NotNull
    public List<TestResults> getSuccessfulTests() {
        return this.passedTests;
    }

    @NotNull
    public List<TestResults> getFailedTests() {
        return this.failedTests;
    }

    @NotNull
    public List<TestResults> getSkippedTests() {
        return this.skippedTests;
    }

    private void parseSuite(SMInputCursor inputCursor) throws XMLStreamException {
        this.suiteName = inputCursor.getAttrValue(ATTR_TEST_METHOD_NAME);
        for (SMInputCursor testCursor : SMInputCursorIterable.fromCursor((SMInputCursor)inputCursor.childElementCursor("test"))) {
            this.testName = testCursor.getAttrValue(ATTR_TEST_METHOD_NAME);
            for (SMInputCursor classCursor : SMInputCursorIterable.fromCursor((SMInputCursor)testCursor.childElementCursor(ATTR_TEST_METHOD_EXCEPTION_CLASS))) {
                this.className = classCursor.getAttrValue(ATTR_TEST_METHOD_NAME);
                for (SMInputCursor testMethodCursor : SMInputCursorIterable.fromCursor((SMInputCursor)classCursor.childElementCursor(ELEM_TEST_METHOD))) {
                    this.parseTestMethod(testMethodCursor);
                }
            }
        }
    }

    private void parseTestMethod(SMInputCursor inputCursor) throws XMLStreamException {
        String methodName = inputCursor.getAttrValue(ATTR_TEST_METHOD_NAME);
        boolean isConfig = Boolean.parseBoolean(inputCursor.getAttrValue(ATTR_TEST_METHOD_IS_CONFIG));
        String status = inputCursor.getAttrValue(ATTR_TEST_METHOD_STATUS);
        long durationMs = Long.parseLong((String)MoreObjects.firstNonNull((Object)inputCursor.getAttrValue(ATTR_TEST_METHOD_DURATION_MS), (Object)"0"));
        TestMethodEntity testMethod = new TestMethodEntity(methodName, isConfig, status, durationMs);
        for (SMInputCursor childCursor : SMInputCursorIterable.fromCursor((SMInputCursor)inputCursor.childElementCursor())) {
            String childCursorLocalName = childCursor.getLocalName();
            if (ELEM_TEST_METHOD_PARAMS.equals(childCursorLocalName)) {
                for (String param : this.parseParams(childCursor)) {
                    testMethod.addParam(param);
                }
                continue;
            }
            if (ELEM_TEST_METHOD_EXCEPTION.equals(childCursorLocalName)) {
                testMethod.setException(this.parseTestMethodException(childCursor));
                continue;
            }
            if (!ELEM_TEST_METHOD_REPORTER_OUTPUT.equals(childCursorLocalName)) continue;
            for (String value : this.parseReporterOutput(childCursor)) {
                testMethod.addReporterOutput(value);
            }
        }
        TestResults testResult = new TestResults(String.format("%s > %s > %s", this.suiteName, this.testName, this.className), testMethod.getFullName(), Long.valueOf(testMethod.getDurationMs()));
        testResult.setState((TestState)STATUS_MAP.get((Object)testMethod.getStatus()));
        testResult.setSystemOut(Joiner.on((String)"\n").join(testMethod.getReporterOutput()));
        if (!testMethod.isConfig()) {
            switch (testResult.getState()) {
                case SUCCESS: {
                    this.passedTests.add(testResult);
                    break;
                }
                case FAILED: {
                    if (testMethod.hasException()) {
                        testResult.addError(testMethod.getException().toTestCaseResultError());
                    }
                    this.failedTests.add(testResult);
                    break;
                }
                case SKIPPED: {
                    this.skippedTests.add(testResult);
                }
            }
        } else if (TestState.FAILED == testResult.getState() && !this.failedTests.contains(testResult)) {
            this.failedTests.add(testResult);
        }
    }

    private List<String> parseParams(SMInputCursor inputCursor) throws XMLStreamException {
        LinkedList<String> params = new LinkedList<String>();
        for (SMInputCursor paramCursor : SMInputCursorIterable.fromCursor((SMInputCursor)inputCursor.childElementCursor(ELEM_TEST_METHOD_PARAM))) {
            for (SMInputCursor valueCursor : SMInputCursorIterable.fromCursor((SMInputCursor)paramCursor.childElementCursor(ELEM_TEST_METHOD_PARAM_VALUE))) {
                params.add(this.concatenateCData(valueCursor));
            }
        }
        return params;
    }

    private List<String> parseReporterOutput(SMInputCursor inputCursor) throws XMLStreamException {
        LinkedList<String> result = new LinkedList<String>();
        for (SMInputCursor lineCursor : SMInputCursorIterable.fromCursor((SMInputCursor)inputCursor.childElementCursor(ELEM_TEST_METHOD_REPORTER_OUTPUT_LINE))) {
            result.add(this.concatenateCData(lineCursor));
        }
        return result;
    }

    private TestMethodExceptionEntity parseTestMethodException(SMInputCursor inputCursor) throws XMLStreamException {
        TestMethodExceptionEntity.Builder builder = TestMethodExceptionEntity.builder();
        builder.className(inputCursor.getAttrValue(ATTR_TEST_METHOD_EXCEPTION_CLASS));
        for (SMInputCursor childCursor : SMInputCursorIterable.fromCursor((SMInputCursor)inputCursor.childElementCursor())) {
            String childCursorLocalName = childCursor.getLocalName();
            if (ELEM_TEST_METHOD_EXCEPTION_MESSAGE.equals(childCursorLocalName)) {
                builder.message(this.concatenateCData(childCursor));
                continue;
            }
            if (!ELEM_TEST_METHOD_EXCEPTION_STACKTRACE.equals(childCursorLocalName)) continue;
            builder.stacktrace(this.concatenateCData(childCursor));
        }
        return builder.build();
    }

    private String concatenateCData(SMInputCursor inputCursor) throws XMLStreamException {
        StringBuilder builder = new StringBuilder();
        for (SMInputCursor cdataCursor : SMInputCursorIterable.fromCursor((SMInputCursor)inputCursor.childCursor(), (SMFilter)new SimpleFilter(SMEvent.CDATA))) {
            builder.append(cdataCursor.getText());
        }
        return builder.toString();
    }
}

