/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.testresultparser.task;

import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ErrorMemorisingInterceptor;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.v2.build.CurrentResult;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class JUnitResultParserTask
implements TaskType {
    private final TestCollationService testCollationService;

    @Inject
    public JUnitResultParserTask(@ComponentImport TestCollationService testCollationService) {
        this.testCollationService = testCollationService;
    }

    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        CurrentResult currentResult = taskContext.getCommonContext().getCurrentResult();
        ErrorMemorisingInterceptor errorLines = ErrorMemorisingInterceptor.newInterceptor();
        taskContext.getBuildLogger().getInterceptorStack().add((LogInterceptor)errorLines);
        try {
            this.testCollationService.collateTestResults(taskContext, (String)taskContext.getConfigurationMap().get((Object)"testResultsDirectory"), Boolean.valueOf((String)taskContext.getConfigurationMap().get((Object)"pickupOutdatedFiles")).booleanValue());
            TaskResult taskResult = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).checkTestFailures().build();
            return taskResult;
        }
        catch (Exception e) {
            throw new TaskException("Failed to execute task", (Throwable)e);
        }
        finally {
            currentResult.addBuildErrors(errorLines.getErrorStringList());
        }
    }
}

