/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.shell.task;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ErrorMemorisingInterceptor;
import com.atlassian.bamboo.plugins.shell.task.ShellConfig;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskContextHelper;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.CurrentResult;
import com.atlassian.utils.process.ExternalProcess;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractShellBuildTask
implements CommonTaskType {
    private static final Logger log = Logger.getLogger(AbstractShellBuildTask.class);
    protected final EnvironmentVariableAccessor environmentVariableAccessor;
    protected final ProcessService processService;

    public AbstractShellBuildTask(EnvironmentVariableAccessor environmentVariableAccessor, ProcessService processService) {
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.processService = processService;
    }

    protected abstract ShellConfig getConfig(@NotNull CommonTaskContext var1);

    @NotNull
    public TaskResult execute(@NotNull CommonTaskContext taskContext) throws TaskException {
        TaskContextHelper.failIfDockerPipelinesEnabled((CommonContext)taskContext.getCommonContext());
        ShellConfig config = this.getConfig(taskContext);
        return this.execute(taskContext, config);
    }

    protected TaskResult execute(CommonTaskContext taskContext, ShellConfig config) throws TaskException {
        ErrorMemorisingInterceptor errorLines = ErrorMemorisingInterceptor.newInterceptor();
        BuildLogger buildLogger = taskContext.getBuildLogger();
        buildLogger.getInterceptorStack().add((LogInterceptor)errorLines);
        try {
            ExternalProcess externalProcess = this.processService.executeExternalProcess(taskContext, new ExternalProcessBuilder().workingDirectory(config.getWorkingDirectory()).env(config.getExtraEnvironment()).command(config.getCommandline()).runWithPowershell(config.isRunWithPowershell()));
            if (externalProcess.getHandler().isComplete()) {
                TaskResult taskResult = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).checkReturnCode(externalProcess).build();
                return taskResult;
            }
            try {
                throw new TaskException("Failed to execute command, external process not completed?");
            }
            catch (Exception e) {
                throw new TaskException("Failed to execute task", (Throwable)e);
            }
        }
        finally {
            CurrentResult currentResult = taskContext.getCommonContext().getCurrentResult();
            currentResult.addBuildErrors(errorLines.getErrorStringList());
        }
    }
}

