/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.script.task;

import com.atlassian.bamboo.agent.elastic.ScriptInterpreterUtils;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.plugins.shell.task.ShellConfig;
import com.atlassian.bamboo.process.CommandlineStringUtils;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ScriptConfig
implements ShellConfig {
    private static final Logger log = Logger.getLogger(ScriptConfig.class);
    public static final String CFG_SCRIPT_FILE = "script";
    public static final String CFG_ARGUMENT = "argument";
    public static final String CFG_SCRIPT_BODY = "scriptBody";
    public static final String CFG_INTERPRETER = "interpreter";
    public static final String CFG_SCRIPT_LOCATION_TYPE = "scriptLocation";
    public static final String CFG_ENVIRONMENT_VARIABLES = "environmentVariables";
    public static final String DEFAULT_UNIX_EXECUTOR = "/bin/sh";
    private final File workingDirectory;
    private String scriptFilename;
    private final String scriptBody;
    private final String argument;
    private final ScriptLocation scriptLocation;
    private final Interpreter interpreter;
    private final Map<String, String> extraEnvironment = new HashMap<String, String>();

    public ScriptConfig(@NotNull CommonTaskContext taskContext, @NotNull EnvironmentVariableAccessor environmentVariableAccessor) {
        ConfigurationMap taskContextConfiguration = taskContext.getConfigurationMap();
        String environmentVariables = StringUtils.defaultString((String)((String)taskContextConfiguration.get((Object)CFG_ENVIRONMENT_VARIABLES)));
        this.workingDirectory = taskContext.getWorkingDirectory();
        this.scriptFilename = (String)taskContextConfiguration.get((Object)CFG_SCRIPT_FILE);
        this.scriptBody = (String)taskContextConfiguration.get((Object)CFG_SCRIPT_BODY);
        this.argument = (String)taskContextConfiguration.get((Object)CFG_ARGUMENT);
        this.scriptLocation = ScriptLocation.valueOf((String)taskContextConfiguration.get((Object)CFG_SCRIPT_LOCATION_TYPE));
        this.interpreter = Interpreter.valueOf((String)taskContextConfiguration.get((Object)CFG_INTERPRETER));
        this.extraEnvironment.putAll(environmentVariableAccessor.splitEnvironmentAssignments(environmentVariables, false));
    }

    @VisibleForTesting
    protected String wrapPowershellCommandIfNecessary(String absolutePath) {
        if (this.isRunWithPowershell() && !absolutePath.contains("`") && absolutePath.contains(" ") && !absolutePath.trim().startsWith("&('")) {
            return "&('" + absolutePath + "')";
        }
        return absolutePath;
    }

    @Override
    public List<String> getCommandline() {
        ArrayList<String> arguments = new ArrayList<String>();
        if (SystemUtils.IS_OS_WINDOWS) {
            if (this.isRunAsExecutable()) {
                Path path = this.workingDirectory.toPath().resolve(this.scriptFilename);
                try {
                    String firstLine = ScriptConfig.getFirstLine(path);
                    String[] interpreterAndArg = ScriptInterpreterUtils.getInterpreter((String)firstLine, (boolean)true);
                    Collections.addAll(arguments, interpreterAndArg);
                }
                catch (Exception e) {
                    log.error((Object)("Unable to determine the interpreter for " + path), (Throwable)e);
                }
            }
        } else if (!this.isRunAsExecutable()) {
            arguments.add(DEFAULT_UNIX_EXECUTOR);
        }
        arguments.add(this.wrapPowershellCommandIfNecessary(this.absolutiseScriptFilenameIfNecessary()));
        if (StringUtils.isNotBlank((CharSequence)this.argument)) {
            arguments.addAll(CommandlineStringUtils.tokeniseCommandline((String)StringUtils.replaceChars((String)this.argument, (String)"\r\n", (String)"  ")));
        }
        return arguments;
    }

    private static String getFirstLine(Path path) throws IOException {
        try (BufferedReader bufferedReader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            String string = bufferedReader.readLine();
            return string;
        }
    }

    public ScriptLocation getScriptLocation() {
        return this.scriptLocation;
    }

    public Interpreter getInterpreter() {
        return this.interpreter;
    }

    public String getScriptFilename() {
        return this.scriptFilename;
    }

    public void setScriptFilename(String scriptFilename) {
        this.scriptFilename = scriptFilename;
    }

    public String getScriptBody() {
        return this.scriptBody;
    }

    @Override
    public Map<String, String> getExtraEnvironment() {
        return this.extraEnvironment;
    }

    @Override
    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public boolean isRunWithPowershell() {
        return this.interpreter == Interpreter.POWERSHELL;
    }

    public boolean isRunAsExecutable() {
        return this.interpreter == Interpreter.RUN_AS_EXECUTABLE;
    }

    String absolutiseScriptFilenameIfNecessary() {
        if (this.scriptFilenameRequiresModification()) {
            return this.workingDirectory.toPath().resolve(this.scriptFilename).toString();
        }
        return this.scriptFilename;
    }

    private boolean scriptFilenameRequiresModification() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return false;
        }
        return this.interpreter == Interpreter.RUN_AS_EXECUTABLE && this.scriptLocation == ScriptLocation.FILE && !this.scriptFilename.contains(File.separator);
    }

    public static enum Interpreter {
        RUN_AS_EXECUTABLE,
        POWERSHELL,
        LEGACY_SH_BAT;

    }

    public static enum ScriptLocation {
        FILE,
        INLINE;

    }
}

