/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.script.task;

import com.atlassian.bamboo.plugins.script.task.ScriptConfig;
import com.atlassian.bamboo.plugins.shell.task.AbstractShellBuildTask;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.setup.HomeDirectoryLayout;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.util.BambooAceUtils;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.util.BambooFilenameUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ScriptBuildTask
extends AbstractShellBuildTask {
    private static final Logger log = Logger.getLogger(ScriptBuildTask.class);
    private final HomeDirectoryLayout homeDirectoryLayout;

    public ScriptBuildTask(EnvironmentVariableAccessor environmentVariableAccessor, ProcessService processService, HomeDirectoryLayout homeDirectoryLayout) {
        super(environmentVariableAccessor, processService);
        this.homeDirectoryLayout = homeDirectoryLayout;
    }

    @Override
    protected ScriptConfig getConfig(@NotNull CommonTaskContext taskContext) {
        return new ScriptConfig(taskContext, this.environmentVariableAccessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public TaskResult execute(@NotNull CommonTaskContext taskContext) throws TaskException {
        TaskResult taskResult;
        block8: {
            ScriptConfig config = this.getConfig(taskContext);
            File scriptFile = null;
            try {
                String message;
                if (config.getScriptLocation() == ScriptConfig.ScriptLocation.INLINE) {
                    scriptFile = this.createTemporaryScriptFile(taskContext, config);
                } else {
                    String scriptFilename = config.getScriptFilename();
                    File file = scriptFile = BambooFilenameUtils.isPathAbsolute((String)scriptFilename) ? new File(scriptFilename) : new File(config.getWorkingDirectory(), scriptFilename);
                }
                if (scriptFile.exists()) {
                    if (config.isRunAsExecutable() && !scriptFile.canExecute()) {
                        message = "Command [" + scriptFile.getAbsolutePath() + "] is not executable, trying to run anyway.";
                        log.warn((Object)message);
                        taskContext.getBuildLogger().addErrorLogEntry(message);
                    }
                } else {
                    message = "File [" + scriptFile.getAbsolutePath() + "] doesn't exist, trying to run [" + config.getScriptFilename() + "] anyway.";
                    log.info((Object)message);
                    taskContext.getBuildLogger().addBuildLogEntry(message);
                }
                taskResult = super.execute(taskContext, config);
                if (config.getScriptLocation() != ScriptConfig.ScriptLocation.INLINE) break block8;
            }
            catch (Throwable throwable) {
                if (config.getScriptLocation() == ScriptConfig.ScriptLocation.INLINE) {
                    BambooFileUtils.deleteQuietly(scriptFile);
                }
                throw throwable;
            }
            BambooFileUtils.deleteQuietly((File)scriptFile);
        }
        return taskResult;
    }

    private File createTemporaryScriptFile(CommonTaskContext taskContext, ScriptConfig config) throws TaskException {
        try {
            String prefix = taskContext.getCommonContext().getResultKey().getKey() + "-" + this.getClass().getSimpleName() + "-";
            File scriptFile = File.createTempFile(prefix, config.isRunWithPowershell() ? ".ps1" : BambooFilenameUtils.getScriptSuffix(), this.homeDirectoryLayout.getTempDirectory());
            FileUtils.writeStringToFile((File)scriptFile, (String)BambooAceUtils.getContentForCurrentPlaform((String)config.getScriptBody()), (Charset)StandardCharsets.UTF_8);
            scriptFile.deleteOnExit();
            scriptFile.setReadOnly();
            scriptFile.setExecutable(true);
            config.setScriptFilename(scriptFile.getAbsolutePath());
            return scriptFile;
        }
        catch (IOException e) {
            throw new TaskException("Error while creating temporary file for script", (Throwable)e);
        }
    }
}

