/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.script.task;

import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.plugins.shell.task.ShellConfig;
import com.atlassian.bamboo.process.CommandlineStringUtils;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ScriptConfig
implements ShellConfig {
    private static final Logger log = Logger.getLogger(ScriptConfig.class);
    public static final String CFG_SCRIPT_FILE = "script";
    public static final String CFG_ARGUMENT = "argument";
    public static final String CFG_SCRIPT_BODY = "scriptBody";
    public static final String CFG_SCRIPT_LOCATION_TYPE = "scriptLocation";
    private static final String CFG_ENVIRONMENT_VARIABLES = "environmentVariables";
    public static final String DEFAULT_UNIX_EXECUTOR = "/bin/sh";
    private final File workingDirectory;
    private String scriptFilename;
    private final String scriptBody;
    private final String argument;
    private final ScriptLocation scriptLocation;
    private final Map<String, String> extraEnvironment = Maps.newHashMap();
    private final boolean runWithPowershell;

    public ScriptConfig(@NotNull CommonTaskContext taskContext, @NotNull EnvironmentVariableAccessor environmentVariableAccessor) {
        ConfigurationMap taskContextConfiguration = taskContext.getConfigurationMap();
        String environmentVariables = (String)taskContextConfiguration.get((Object)CFG_ENVIRONMENT_VARIABLES);
        this.workingDirectory = taskContext.getWorkingDirectory();
        this.scriptFilename = (String)taskContextConfiguration.get((Object)CFG_SCRIPT_FILE);
        this.scriptBody = (String)taskContextConfiguration.get((Object)CFG_SCRIPT_BODY);
        this.argument = (String)taskContextConfiguration.get((Object)CFG_ARGUMENT);
        this.scriptLocation = ScriptLocation.valueOf((String)taskContextConfiguration.get((Object)CFG_SCRIPT_LOCATION_TYPE));
        this.runWithPowershell = taskContextConfiguration.getAsBoolean("runWithPowershell");
        this.extraEnvironment.putAll(environmentVariableAccessor.splitEnvironmentAssignments(environmentVariables, false));
    }

    @Override
    public List<String> getCommandline() {
        ArrayList arguments = Lists.newArrayList();
        if (!SystemUtils.IS_OS_WINDOWS) {
            arguments.add(DEFAULT_UNIX_EXECUTOR);
        }
        arguments.add(this.scriptFilename);
        if (StringUtils.isNotBlank((String)this.argument)) {
            arguments.addAll(CommandlineStringUtils.tokeniseCommandline((String)StringUtils.replaceChars((String)this.argument, (String)"\r\n", (String)"  ")));
        }
        return arguments;
    }

    public ScriptLocation getScriptLocation() {
        return this.scriptLocation;
    }

    public String getScriptBody() {
        return this.scriptBody;
    }

    public void setScriptFilename(String scriptFilename) {
        this.scriptFilename = scriptFilename;
    }

    @Override
    public Map<String, String> getExtraEnvironment() {
        return this.extraEnvironment;
    }

    @Override
    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public boolean isRunWithPowershell() {
        return this.runWithPowershell;
    }

    public static enum ScriptLocation {
        FILE("FILE"),
        INLINE("INLINE");

        private final String name;

        private ScriptLocation(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

