/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.command.task.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plugins.shell.configuration.AbstractShellCommandTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskRequirementSupport;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.opensymphony.xwork2.TextProvider;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class CommandBuildTaskConfigurator
extends AbstractShellCommandTaskConfigurator
implements TaskRequirementSupport {
    private static final List<String> FIELDS_TO_COPY = ImmutableList.of((Object)"environmentVariables", (Object)"workingSubDirectory", (Object)"label", (Object)"argument", (Object)"runWithPowershell");
    private TextProvider textProvider;

    @Override
    @NotNull
    protected List<String> getFieldsToCopy() {
        return FIELDS_TO_COPY;
    }

    @NotNull
    public Set<Requirement> calculateRequirements(@NotNull TaskDefinition taskDefinition) {
        HashSet requirements = Sets.newHashSet();
        this.taskConfiguratorHelper.addSystemRequirementFromConfiguration((Set)requirements, taskDefinition, "label", "system.builder.command");
        return requirements;
    }

    @Override
    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        if (StringUtils.isEmpty((String)params.getString("label"))) {
            errorCollection.addError("label", this.textProvider.getText("task.command.validate.command.mandatory"));
        }
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }
}

