/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcsversion;

import com.atlassian.bamboo.build.CustomPreBuildAction;
import com.atlassian.bamboo.repository.cvsimpl.CVSRepository;
import com.atlassian.bamboo.repository.perforce.PerforceRepository;
import com.atlassian.bamboo.repository.svn.SvnRepository;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.repository.RepositoryV2;
import com.atlassian.bamboo.v2.build.task.AbstractBuildTask;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class VCSVersionReader
extends AbstractBuildTask
implements CustomPreBuildAction {
    private static final Logger log = Logger.getLogger(VCSVersionReader.class);
    public static final String SVN_REVISION_NUMBER = "custom.svn.revision.number";
    public static final String SVN_LASTCHANGE_REVISION_NUMBER = "custom.svn.lastchange.revision.number";
    public static final String CVS_UPDATE_TIME = "custom.cvs.last.update.time";
    public static final String CVS_UPDATE_TIME_LABEL = "custom.cvs.last.update.time.label";
    public static final String P4_REVISION_NUMBER = "custom.p4.revision.number";

    @NotNull
    public BuildContext call() throws Exception {
        RepositoryV2 repository = this.buildContext.getBuildPlanDefinition().getRepositoryV2();
        String latestRevision = this.buildContext.getBuildChanges().getVcsRevisionKey();
        Map customDataMap = this.buildContext.getBuildResult().getCustomBuildData();
        if (latestRevision != null && repository != null) {
            if (repository instanceof SvnRepository) {
                customDataMap.put(SVN_REVISION_NUMBER, latestRevision);
                if (this.buildContext.getBuildChanges().getVcsLastChangeRevisionKey() != null) {
                    customDataMap.put(SVN_LASTCHANGE_REVISION_NUMBER, this.buildContext.getBuildChanges().getVcsLastChangeRevisionKey());
                }
            } else if (repository instanceof PerforceRepository) {
                customDataMap.put(P4_REVISION_NUMBER, latestRevision);
            } else if (repository instanceof CVSRepository) {
                customDataMap.put(CVS_UPDATE_TIME, latestRevision);
                customDataMap.put(CVS_UPDATE_TIME_LABEL, latestRevision.replaceAll("\\s", "_"));
            }
        }
        return this.buildContext;
    }

    public ErrorCollection validate(BuildConfiguration buildConfiguration) {
        return null;
    }
}

