/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.php.task;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ContentMatchingInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ErrorMemorisingInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.LogMemorisingInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.StringMatchingInterceptor;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.builder.MavenLogHelper;
import com.atlassian.bamboo.plugins.php.task.PhpUnitConfig;
import com.atlassian.bamboo.plugins.php.task.utils.PhpUnitBuildTaskHelper;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskIdentifier;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.build.CurrentResult;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.utils.process.ExternalProcess;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PhpUnitBuildTask
implements TaskType {
    private static final Logger log = Logger.getLogger(PhpUnitBuildTask.class);
    private static final String BUILD_SUCCESSFUL_MARKER = "OK";
    private static final boolean SEARCH_BUILD_SUCCESS_FAIL_MESSAGE_EVERYWHERE = SystemProperty.SEARCH_BUILD_SUCCESS_FAIL_MESSAGE_EVERYWHERE.getValue(false);
    private static final int FIND_SUCCESS_MESSAGE_IN_LAST = SystemProperty.FIND_SUCCESS_MESSAGE_IN_LAST.getValue(250);
    private static final int LINES_TO_PARSE_FOR_ERRORS = 200;
    protected final CapabilityContext capabilityContext;
    protected final EnvironmentVariableAccessor environmentVariableAccessor;
    protected final ProcessService processService;
    protected final TestCollationService testCollationService;

    public PhpUnitBuildTask(CapabilityContext capabilityContext, EnvironmentVariableAccessor environmentVariableAccessor, ProcessService processService, TestCollationService testCollationService) {
        this.capabilityContext = capabilityContext;
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.processService = processService;
        this.testCollationService = testCollationService;
    }

    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        BuildLogger buildLogger = taskContext.getBuildLogger();
        CurrentResult currentResult = taskContext.getCommonContext().getCurrentResult();
        PhpUnitConfig config = PhpUnitBuildTaskHelper.createConfig((TaskIdentifier)taskContext, taskContext, this.capabilityContext, this.environmentVariableAccessor);
        StringMatchingInterceptor buildSuccessMatcher = new StringMatchingInterceptor(BUILD_SUCCESSFUL_MARKER, SEARCH_BUILD_SUCCESS_FAIL_MESSAGE_EVERYWHERE);
        buildLogger.getInterceptorStack().add((LogInterceptor)buildSuccessMatcher);
        ErrorMemorisingInterceptor errorLines = ErrorMemorisingInterceptor.newInterceptor();
        buildLogger.getInterceptorStack().add((LogInterceptor)errorLines);
        LogMemorisingInterceptor recentLogLines = new LogMemorisingInterceptor(200);
        buildLogger.getInterceptorStack().add((LogInterceptor)recentLogLines);
        try {
            ExternalProcess externalProcess = this.processService.executeProcess(taskContext, new ExternalProcessBuilder().workingDirectory(config.getWorkingDirectory()).env(config.getExtraEnvironment()).command(config.getCommandline()));
            if (externalProcess.getHandler().isComplete()) {
                String logJunitFilename;
                TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).checkReturnCode(externalProcess).checkInterceptorMatches((ContentMatchingInterceptor)buildSuccessMatcher, FIND_SUCCESS_MESSAGE_IN_LAST);
                if (config.isLogJunitEnabled() && (logJunitFilename = config.getLogJunitFilename()) != null) {
                    this.testCollationService.collateTestResults(taskContext, logJunitFilename);
                    taskResultBuilder.checkTestFailures();
                }
                TaskResult taskResult = taskResultBuilder.build();
                return taskResult;
            }
            try {
                throw new TaskException("Failed to execute command, external process not completed?");
            }
            catch (Exception e) {
                throw new TaskException("Failed to execute task", (Throwable)e);
            }
        }
        finally {
            currentResult.addBuildErrors(errorLines.getErrorStringList());
            currentResult.addBuildErrors(MavenLogHelper.parseErrorOutput((Iterable)recentLogLines.getLogEntries()));
        }
    }
}

