/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.php.task;

import com.atlassian.bamboo.plugins.php.task.AbstractPhpUnitConfig;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PhpUnit33XConfigImpl
extends AbstractPhpUnitConfig {
    private static final Logger log = Logger.getLogger(PhpUnit33XConfigImpl.class);
    public static final String PHPUNIT_33X_CAPABILITY_PREFIX = "system.builder.phpunit33X";
    private static final String OPT_LOG_XML = "--log-xml";
    private static final String OPT_COVERAGE_HTML = "--coverage-html";

    public PhpUnit33XConfigImpl(@NotNull TaskContext taskContext, @NotNull CapabilityContext capabilityContext, @NotNull EnvironmentVariableAccessor environmentVariableAccessor) {
        super(taskContext, capabilityContext, PHPUNIT_33X_CAPABILITY_PREFIX, environmentVariableAccessor);
    }

    @Override
    @NotNull
    protected List<String> buildCommandline() {
        String directoryName;
        String filename;
        ImmutableList.Builder listBuilder = new ImmutableList.Builder().add((Object)this.getBuilderPath());
        if (this.isLogJunitEnabled() && (filename = BambooFileUtils.relativizePath((File)this.getRootDirectory(), (File)this.getWorkingDirectory(), (String)this.getLogJunitFilename())) != null) {
            listBuilder.add((Object[])new String[]{OPT_LOG_XML, filename});
        }
        if (this.isCoverageHtmlEnabled() && (directoryName = BambooFileUtils.relativizePath((File)this.getRootDirectory(), (File)this.getWorkingDirectory(), (String)this.getCoverageHtmlDirectoryName())) != null) {
            listBuilder.add((Object[])new String[]{OPT_COVERAGE_HTML, directoryName});
        }
        listBuilder.addAll(this.getArguments());
        return listBuilder.build();
    }
}

