/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.visualstudio;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ErrorMemorisingInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.LogMemorisingInterceptor;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.plugin.dotnet.support.DotNetLogHelper;
import com.atlassian.bamboo.plugin.dotnet.visualstudio.RunnerExtractor;
import com.atlassian.bamboo.process.CommandlineStringUtils;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class VisualStudioTaskType
implements TaskType {
    public static final String VS_CAPABILITY_PREFIX = "system.builder.devenv";
    public static final String SOLUTION = "solution";
    public static final String OPTIONS = "options";
    public static final String LABEL = "label";
    public static final String VS_ENVIRONMENT = "vsEnvironment";
    public static final String ENVIRONMENT = "environmentVariables";
    private static final int LINES_TO_PARSE_FOR_ERRORS = 200;
    private final ProcessService processService;
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private final CapabilityContext capabilityContext;

    public VisualStudioTaskType(ProcessService processService, EnvironmentVariableAccessor environmentVariableAccessor, CapabilityContext capabilityContext) {
        this.processService = processService;
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.capabilityContext = capabilityContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) {
        BuildLogger buildLogger = taskContext.getBuildLogger();
        CurrentBuildResult currentBuildResult = taskContext.getBuildContext().getBuildResult();
        LogMemorisingInterceptor recentLogLines = new LogMemorisingInterceptor(200);
        ErrorMemorisingInterceptor errorLines = ErrorMemorisingInterceptor.newInterceptor();
        buildLogger.getInterceptorStack().add((LogInterceptor)recentLogLines);
        buildLogger.getInterceptorStack().add((LogInterceptor)errorLines);
        try {
            String runnerPath = RunnerExtractor.getDevenvRunnerPath();
            Preconditions.checkNotNull((Object)runnerPath, (Object)"Visual Studio Runner");
            ConfigurationMap configuration = taskContext.getConfigurationMap();
            String visualStudioEnvironment = (String)configuration.get((Object)VS_ENVIRONMENT);
            if (StringUtils.isEmpty((CharSequence)visualStudioEnvironment)) {
                visualStudioEnvironment = "x86";
            }
            Preconditions.checkNotNull((Object)visualStudioEnvironment, (Object)"Visual Studio Environment");
            String label = (String)configuration.get((Object)LABEL);
            Preconditions.checkNotNull((Object)label);
            String solution = (String)configuration.get((Object)SOLUTION);
            Preconditions.checkNotNull((Object)solution, (Object)"Solution");
            Map<String, String> environment = this.getEnvironment(taskContext);
            Preconditions.checkNotNull(environment, (Object)"Process Environment");
            String installationDirectory = this.getVisualStudioInstallationDirectory(label);
            Preconditions.checkNotNull((Object)installationDirectory, (Object)"Could not find Visual Studio installation directory");
            ArrayList<String> command = new ArrayList<String>(Arrays.asList(runnerPath, taskContext.getWorkingDirectory().getAbsolutePath(), installationDirectory, visualStudioEnvironment, solution));
            command.addAll(this.getOptions(taskContext));
            TaskResult taskResult = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).checkReturnCode(this.processService.executeExternalProcess((CommonTaskContext)taskContext, new ExternalProcessBuilder().command(command).env(environment).workingDirectory(taskContext.getWorkingDirectory()))).build();
            return taskResult;
        }
        finally {
            currentBuildResult.addBuildErrors(errorLines.getErrorStringList());
            currentBuildResult.addBuildErrors(DotNetLogHelper.parseErrorOutput(recentLogLines.getLogEntries()));
        }
    }

    @NotNull
    private Map<String, String> getEnvironment(TaskContext taskContext) {
        String environment = (String)taskContext.getConfigurationMap().get((Object)ENVIRONMENT);
        return this.environmentVariableAccessor.splitEnvironmentAssignments(environment);
    }

    @NotNull
    List<String> getOptions(TaskContext taskContext) {
        String options = (String)taskContext.getConfigurationMap().get((Object)OPTIONS);
        return ImmutableList.copyOf((Collection)CommandlineStringUtils.tokeniseCommandline((String)options));
    }

    private String getVisualStudioInstallationDirectory(String label) {
        Capability capability = this.capabilityContext.getCapabilitySet().getCapability("system.builder.devenv." + label);
        Preconditions.checkNotNull((Object)capability, (Object)"Capability");
        return new File(capability.getValue()).getParentFile().getParent();
    }
}

