/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.tests.mstest;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plugin.dotnet.support.AbstractDotNetTaskConfigurator;
import com.atlassian.bamboo.task.BuildTaskRequirementSupport;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskTestResultsSupport;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MSTestRunnerConfigurator
extends AbstractDotNetTaskConfigurator
implements BuildTaskRequirementSupport,
TaskTestResultsSupport {
    private static final Set<String> FIELDS_TO_COPY = Sets.newHashSet((Object[])new String[]{"label", "mstestContainer", "mstestRunConfig", "resultsfile", "testmetadata", "environmentVariables"});
    private static final String DEFAULT_TEST_FILE = "testresults.trx";

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        String label = params.getString("label");
        if (StringUtils.isEmpty((CharSequence)label)) {
            errorCollection.addError("label", this.textProvider.getText("mstest.label.error"));
        }
        String container = params.getString("mstestContainer");
        String testMetadata = params.getString("testmetadata");
        if (StringUtils.isNotEmpty((CharSequence)container) && StringUtils.isNotEmpty((CharSequence)testMetadata)) {
            errorCollection.addError("testmetadata", this.textProvider.getText("mstest.has.both.testMetadata.container"));
            errorCollection.addError("mstestContainer", this.textProvider.getText("mstest.has.both.testMetadata.container"));
        } else if (StringUtils.isEmpty((CharSequence)container) && StringUtils.isEmpty((CharSequence)testMetadata)) {
            errorCollection.addError("testmetadata", this.textProvider.getText("mstest.has.neither.testMetadata.container"));
            errorCollection.addError("mstestContainer", this.textProvider.getText("mstest.has.neither.testMetadata.container"));
        }
        String resultsFile = params.getString("resultsfile");
        if (StringUtils.isEmpty((CharSequence)resultsFile)) {
            errorCollection.addError("resultsfile", this.textProvider.getText("mstest.resultsFile.error"));
        }
        if (StringUtils.isNotBlank((CharSequence)resultsFile) && !resultsFile.endsWith(".trx")) {
            errorCollection.addError("resultsfile", this.textProvider.getText("mstest.resultsFile.missingExtension"));
        }
    }

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("resultsfile", DEFAULT_TEST_FILE);
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.taskConfiguratorHelper.populateContextWithConfiguration(context, taskDefinition, FIELDS_TO_COPY);
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map map = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(map, params, FIELDS_TO_COPY);
        return map;
    }

    @NotNull
    public Set<Requirement> calculateRequirements(@NotNull TaskDefinition taskDefinition, @NotNull Job job) {
        HashSet<Requirement> requirements = new HashSet<Requirement>();
        this.taskConfiguratorHelper.addSystemRequirementFromConfiguration(requirements, taskDefinition, "label", "system.builder.devenv");
        return requirements;
    }

    public boolean taskProducesTestResults(@NotNull TaskDefinition taskDefinition) {
        return true;
    }
}

