/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.tests;

import com.atlassian.bamboo.build.test.TestCollectionResult;
import com.atlassian.bamboo.build.test.TestCollectionResultBuilder;
import com.atlassian.bamboo.build.test.TestReportCollector;
import com.atlassian.bamboo.plugin.dotnet.tests.TestResultsParser;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TestReportCollectorImpl
implements TestReportCollector {
    private TestResultsParser parser;

    public TestReportCollectorImpl(TestResultsParser parser) {
        this.parser = parser;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public TestCollectionResult collect(@NotNull File file) throws Exception {
        try (FileInputStream inputStream = new FileInputStream(file);){
            this.parser.parse(inputStream);
            TestCollectionResult testCollectionResult = new TestCollectionResultBuilder().addSuccessfulTestResults(this.parser.getSuccessfulTests()).addFailedTestResults(this.parser.getFailedTests()).addSkippedTestResults(this.parser.getInconclusiveTests()).build();
            return testCollectionResult;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public Set<String> getSupportedFileExtensions() {
        return Sets.newHashSet((Object[])new String[]{"trx", "xml"});
    }
}

