/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.ncover;

import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import javax.inject.Inject;

public class NCoverResultWebItemCondition
implements Condition {
    @Inject
    private ResultsSummaryManager resultsSummaryManager;

    public void init(Map map) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        String planKey = (String)context.get("buildKey");
        String buildNumber = (String)context.get("buildNumber");
        if (planKey == null || buildNumber == null) {
            return false;
        }
        PlanResultKey planResultKey = PlanKeys.getPlanResultKey((String)planKey, (int)Integer.parseInt(buildNumber));
        ResultsSummary summary = this.resultsSummaryManager.getResultsSummary(planResultKey);
        if (summary == null) {
            return false;
        }
        Map customData = summary.getCustomBuildData();
        return customData.containsKey("NCOVER_LINE_RATE");
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }
}

