/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.ncover;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainExecution;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.chains.plugins.PostChainAction;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.util.NumberUtils;
import org.jetbrains.annotations.NotNull;

public class NCoverChainResultAggregator
implements PostChainAction {
    public void execute(@NotNull Chain chain, @NotNull ChainResultsSummary chainResultsSummary, @NotNull ChainExecution chainExecution) {
        this.execute((ImmutableChain)chain, chainResultsSummary, chainExecution);
    }

    public void execute(@NotNull ImmutableChain immutableChain, @NotNull ChainResultsSummary chainResultsSummary, @NotNull ChainExecution chainExecution) {
        if (!chainResultsSummary.isSuccessful()) {
            return;
        }
        double aggregatedLineRate = 0.0;
        int aggregatedLineRateCnt = 0;
        for (ChainStageResult stageResult : chainResultsSummary.getStageResults()) {
            for (BuildResultsSummary buildResult : stageResult.getBuildResults()) {
                Double lineRate = NumberUtils.createDoubleQuietly((String)((String)buildResult.getCustomBuildData().get("NCOVER_LINE_RATE")));
                if (lineRate == null) continue;
                aggregatedLineRate += lineRate.doubleValue();
                ++aggregatedLineRateCnt;
            }
        }
        if (aggregatedLineRateCnt > 0) {
            chainResultsSummary.getCustomBuildData().put("NCOVER_LINE_RATE", Double.toString(aggregatedLineRate / (double)aggregatedLineRateCnt));
        }
    }
}

