package com.atlassian.bamboo.plugin.dotnet.ncover;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.index.CustomPostBuildIndexWriter;
import com.atlassian.bamboo.index.PostChainIndexWriter;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.jetbrains.annotations.NotNull;

import java.text.NumberFormat;
import java.text.ParseException;

/**
 * Handles persisting results obtained from parsing the NCover XML report file.
 *
 * @author Ross Rowe
 */
public class NCoverPostBuildIndexWriter implements  CustomPostBuildIndexWriter, PostChainIndexWriter
{

	private static final Logger log = Logger.getLogger(NCoverPostBuildIndexWriter.class);

	/**
	 * Updates the <code>Document</code> with the results that have been stored
	 * in the <code>BuildResultsSummary</code> parameter.
	 *
	 * @param document
	 * @param resultsSummary
	 *            the build results summary
	 */
	@Override
    public void updateIndexDocument(@NotNull Document document, @NotNull BuildResultsSummary resultsSummary)
    {
        updateIndex(document, resultsSummary);
    }

    @Override
    public void updateIndexDocument(@NotNull final Document document, @NotNull final ChainResultsSummary resultsSummary)
    {
        updateIndex(document, resultsSummary);
    }

    private void updateIndex(final Document document, final ResultsSummary resultsSummary)
    {
        String coverStr = resultsSummary.getCustomBuildData().get(NCoverBuildProcessor.NCOVER_LINE_RATE);
        if (coverStr == null)
        {
            return;
        }

        final NumberFormat numberFormat = NumberFormat.getInstance();
        try {
            final Number number = numberFormat.parse(coverStr);
            final double coverDbl = number.doubleValue();

            document.add(new StoredField(NCoverBuildProcessor.NCOVER_LINE_RATE, coverDbl));
        } catch (final ParseException e) {
            log.error(e);
        }
    }
}
