/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.tests.nunit;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plugin.dotnet.support.AbstractDotNetTaskConfigurator;
import com.atlassian.bamboo.task.BuildTaskRequirementSupport;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskTestResultsSupport;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NUnitRunnerConfigurator
extends AbstractDotNetTaskConfigurator
implements TaskTestResultsSupport,
BuildTaskRequirementSupport {
    private static final Logger log = Logger.getLogger(NUnitRunnerConfigurator.class);
    private static final String DEFAULT_TEST_FILE = "TestResult.xml";
    private static final Set<String> FIELDS_TO_COPY = Sets.newHashSet((Object[])new String[]{"label", "nunitTestFiles", "nunitResultsFile", "run", "include", "exclude", "commandLineOptions", "environmentVariables"});

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        String resultsFile;
        String testFiles;
        super.validate(params, errorCollection);
        String label = params.getString("label");
        if (StringUtils.isEmpty((CharSequence)label)) {
            errorCollection.addError("label", this.textProvider.getText("nunit.label.error"));
        }
        if (StringUtils.isEmpty((CharSequence)(testFiles = params.getString("nunitTestFiles")))) {
            errorCollection.addError("nunitTestFiles", this.textProvider.getText("nunit.testFiles.error"));
        }
        if (StringUtils.isNotBlank((CharSequence)(resultsFile = params.getString("nunitResultsFile")))) {
            if (!resultsFile.endsWith(".xml")) {
                errorCollection.addError("nunitResultsFile", this.textProvider.getText("nunit.resultsFile.incorrectExtension"));
            }
        } else {
            errorCollection.addError("nunitResultsFile", this.textProvider.getText("nunit.resultsFile.missing"));
        }
    }

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("nunitResultsFile", DEFAULT_TEST_FILE);
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.taskConfiguratorHelper.populateContextWithConfiguration(context, taskDefinition, FIELDS_TO_COPY);
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map map = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(map, params, FIELDS_TO_COPY);
        return map;
    }

    public boolean taskProducesTestResults(@NotNull TaskDefinition taskDefinition) {
        return true;
    }

    @NotNull
    public Set<Requirement> calculateRequirements(@NotNull TaskDefinition taskDefinition, @NotNull Job job) {
        return Sets.newHashSet((Object[])new Requirement[]{this.taskConfiguratorHelper.createRequirementFromConfiguration(taskDefinition, "label")});
    }
}

