/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.tests.nunit;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plugin.dotnet.support.AbstractDotNetTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskTestResultsSupport;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NUnitConfigurator
extends AbstractDotNetTaskConfigurator
implements TaskTestResultsSupport {
    private static final Logger log = Logger.getLogger(NUnitConfigurator.class);
    private static final String DEFAULT_TEST_DIRECTORY = "**/test-reports/*.xml";
    private static final Set<String> FIELDS_TO_COPY = Sets.newHashSet((Object[])new String[]{"testResultsDirectory", "pickupOutdatedFiles"});

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        String testDirectory = params.getString("testResultsDirectory");
        if (StringUtils.isEmpty((CharSequence)testDirectory)) {
            errorCollection.addError("testResultsDirectory", this.textProvider.getText("nunit.testDirectory.error"));
        }
    }

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("testResultsDirectory", DEFAULT_TEST_DIRECTORY);
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.taskConfiguratorHelper.populateContextWithConfiguration(context, taskDefinition, FIELDS_TO_COPY);
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map map = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(map, params, FIELDS_TO_COPY);
        return map;
    }

    public boolean taskProducesTestResults(@NotNull TaskDefinition taskDefinition) {
        return true;
    }
}

