/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.tests.nunit;

import com.atlassian.bamboo.plugin.dotnet.msbuild.WindowsSystemPaths;
import com.atlassian.bamboo.utils.Which;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityDefaultsHelper;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.google.common.base.MoreObjects;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;

public class NUnitCapabilityDefaultsHelper
implements CapabilityDefaultsHelper {
    private static final Pattern NUNIT_DIRECTORY_PATTERN = Pattern.compile("NUnit \\d+\\.\\d+(\\.\\d+)?");
    private static final String NUNIT3_CONSOLE_EXE = "nunit3-console.exe";
    private static final String NUNIT_CONSOLE_EXE = "nunit-console.exe";
    private static final String NUNIT_CONSOLE_X86_EXE = "nunit-console-x86.exe";
    private static final FilenameFilter NUNIT_DIRECTORY_MATCHER = (dir, name) -> NUNIT_DIRECTORY_PATTERN.matcher(name).matches();

    @NotNull
    public CapabilitySet addDefaultCapabilities(@NotNull CapabilitySet capabilitySet) {
        return SystemUtils.IS_OS_WINDOWS ? NUnitCapabilityDefaultsHelper.getWindowsCapabilityDefaults(capabilitySet) : NUnitCapabilityDefaultsHelper.getGenericCapabilityDefaults(capabilitySet);
    }

    @NotNull
    private static CapabilitySet getGenericCapabilityDefaults(@NotNull CapabilitySet capabilitySet) {
        NUnitCapabilityDefaultsHelper.addExecutable(capabilitySet, NUNIT_CONSOLE_EXE, "system.builder.nunit.NUnit");
        NUnitCapabilityDefaultsHelper.addExecutable(capabilitySet, NUNIT3_CONSOLE_EXE, "system.builder.nunit3.NUnit 3");
        NUnitCapabilityDefaultsHelper.addExecutable(capabilitySet, NUNIT_CONSOLE_X86_EXE, "system.builder.nunit.NUnit (32bit)");
        return capabilitySet;
    }

    private static void addExecutable(@NotNull CapabilitySet capabilitySet, String executableName, String capabilityKey) {
        String path = Which.execute((String)executableName);
        if (!StringUtils.isBlank((CharSequence)path)) {
            CapabilityImpl capability = new CapabilityImpl(capabilityKey, path);
            capabilitySet.addCapability((Capability)capability);
        }
    }

    @NotNull
    private static CapabilitySet getWindowsCapabilityDefaults(@NotNull CapabilitySet capabilitySet) {
        for (File installDirectory : NUnitCapabilityDefaultsHelper.getNunitInstallDirectories()) {
            if (!installDirectory.isDirectory()) continue;
            NUnitCapabilityDefaultsHelper.probeDirectory(installDirectory, capabilitySet);
        }
        return capabilitySet;
    }

    private static Iterable<File> getNunitInstallDirectories() {
        return WindowsSystemPaths.getProgramFilesDirectories().stream().map(NUnitCapabilityDefaultsHelper::listNunitDirs).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static List<File> listNunitDirs(File dir) {
        return Arrays.asList((Object[])MoreObjects.firstNonNull((Object)dir.listFiles(NUNIT_DIRECTORY_MATCHER), (Object)new File[0]));
    }

    private static void probeDirectory(@NotNull File installDirectory, @NotNull CapabilitySet capabilitySet) {
        String nunitCapabilityKey = "system.builder.nunit." + installDirectory.getName();
        String nunit3CapabilityKey = "system.builder.nunit3." + installDirectory.getName();
        NUnitCapabilityDefaultsHelper.addAsCapabilityIfExists(new File(installDirectory, "bin/net-2.0/nunit-console.exe"), capabilitySet, nunitCapabilityKey);
        NUnitCapabilityDefaultsHelper.addAsCapabilityIfExists(new File(installDirectory, "bin/net-2.0/nunit-console-x86.exe"), capabilitySet, nunitCapabilityKey + " (32bit)");
        NUnitCapabilityDefaultsHelper.addAsCapabilityIfExists(new File(installDirectory, "bin/nunit-console.exe"), capabilitySet, nunitCapabilityKey);
        NUnitCapabilityDefaultsHelper.addAsCapabilityIfExists(new File(installDirectory, "bin/nunit-console-x86.exe"), capabilitySet, nunitCapabilityKey + " (32bit)");
        NUnitCapabilityDefaultsHelper.addAsCapabilityIfExists(new File(installDirectory, "bin/nunit3-console.exe"), capabilitySet, nunit3CapabilityKey);
    }

    private static void addAsCapabilityIfExists(File executable, @NotNull CapabilitySet capabilitySet, String capabilityKey) {
        if (executable.isFile()) {
            CapabilityImpl capability = new CapabilityImpl(capabilityKey, executable.getAbsolutePath());
            capabilitySet.addCapability((Capability)capability);
        }
    }
}

