/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.support;

import com.atlassian.bamboo.build.LogEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DotNetLogHelper
implements Serializable {
    private static final Logger log = Logger.getLogger(DotNetLogHelper.class);

    public static List<String> parseErrorOutput(Iterable<LogEntry> logsToParse) {
        return DotNetLogHelper.parseErrorOutput(logsToParse, new ErrorMatcher());
    }

    private static List<String> parseErrorOutput(Iterable<LogEntry> logsToParse, ErrorMatcher fatalMatcher) {
        DotNetLogHelper.parseLogs(fatalMatcher, logsToParse);
        return fatalMatcher.getErrorLogs();
    }

    private static void parseLogs(ErrorMatcher matcher, Iterable<LogEntry> logsToParse) {
        String previousLog = null;
        for (LogEntry logEntry : logsToParse) {
            String currentLog = logEntry.getUnstyledLog();
            matcher.match(previousLog, currentLog);
            previousLog = currentLog;
        }
    }

    private static class ErrorMatcher {
        private boolean matched;
        private List<String> errorLogs = new ArrayList<String>();
        private static final String ERROR_MESSAGE_INDICATOR = ": error ";

        private ErrorMatcher() {
        }

        public void match(String previousLog, String currentLog) {
            if (this.matched) {
                if (!this.isEnd(previousLog, currentLog)) {
                    this.errorLogs.add(previousLog);
                } else {
                    this.matched = false;
                }
            } else if (this.isStart(previousLog, currentLog)) {
                if (previousLog != null) {
                    this.errorLogs.add(previousLog);
                }
                this.matched = true;
            }
        }

        public List<String> getErrorLogs() {
            return this.errorLogs;
        }

        private boolean isEnd(String previousLog, String currentLog) {
            return previousLog != null && !previousLog.contains(ERROR_MESSAGE_INDICATOR);
        }

        private boolean isStart(String previousLog, String currentLog) {
            return currentLog != null && currentLog.contains(ERROR_MESSAGE_INDICATOR);
        }
    }
}

