/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.ncover;

import com.atlassian.bamboo.plugin.dotnet.ncover.NCoverBuildProcessor;
import com.atlassian.bamboo.plugin.dotnet.ncover.NCoverEntityResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;

public class NCoverReportParser {
    private static final Logger log = Logger.getLogger(NCoverReportParser.class);
    private long elements;
    private long classes;
    private long methods;
    private double lineRate;
    private String csv;
    private Long linesOfCode;
    private long assemblies;
    private Long linesExecuted;
    private Long linesNotExecuted;

    public Long getLinesExecuted() {
        return this.linesExecuted;
    }

    public Long getLinesOfCode() {
        return this.linesOfCode;
    }

    public void parse(InputStream stream) throws ParserConfigurationException, IOException, XPathExpressionException, DocumentException {
        log.debug((Object)"About to parse");
        SAXReader reader = new SAXReader();
        reader.setEntityResolver((EntityResolver)new NCoverEntityResolver());
        Document document = reader.read(stream);
        this.parse(document);
    }

    public void parse(Document document) throws XPathExpressionException {
        log.debug((Object)"About to parse document");
        this.linesOfCode = this.getLongValueFromNode((Node)document, "count(//seqpnt)");
        this.linesExecuted = this.getLongValueFromNode((Node)document, "count(//seqpnt[not(@vc=0 or @visitcount=0)])");
        this.lineRate = this.linesExecuted.doubleValue() / this.linesOfCode.doubleValue();
        this.linesNotExecuted = this.linesOfCode - this.linesExecuted;
        this.classes = this.getLongValueFromNode((Node)document, "count(//class)");
        this.methods = this.getLongValueFromNode((Node)document, "count(//method)");
        this.assemblies = this.getLongValueFromNode((Node)document, "count(/coverage/module)");
        if (this.classes == 0L) {
            Set<String> processedClasses = this.getProcessedClasses(document);
            this.classes = processedClasses.size();
        } else {
            this.csv = this.processClasses(document);
        }
    }

    private Set<String> getProcessedClasses(Document document) {
        HashSet<String> classes = new HashSet<String>();
        List nodes = document.selectNodes("//method");
        for (Object o : nodes) {
            Node node = (Node)o;
            Node nameAttribute = (Node)node.selectObject("@class");
            classes.add(nameAttribute.getStringValue());
        }
        return classes;
    }

    private String processClasses(Document document) {
        StringBuffer buffer = new StringBuffer();
        List nodes = document.selectNodes("//class");
        for (Object o : nodes) {
            Node node = (Node)o;
            Node nameAttribute = (Node)node.selectObject("@name");
            log.debug((Object)("Processing class: " + nameAttribute.getStringValue()));
            Double total = (Double)node.selectObject("count(./method/seqpnt)");
            Double visited = (Double)node.selectObject("count(./method/seqpnt[not(@vc=0 or @visitcount=0)])");
            buffer.append(nameAttribute.getStringValue()).append(',');
            buffer.append(visited / total).append(NCoverBuildProcessor.LINE_SEPARATOR);
        }
        return buffer.toString();
    }

    public void parse(File file) throws IOException, DocumentException, ParserConfigurationException, XPathExpressionException {
        try (FileInputStream is = new FileInputStream(file);){
            this.parse(is);
        }
    }

    private long getLongValueFromNode(Node node, String xpathExpression) throws XPathExpressionException {
        log.debug((Object)("Running xpath: " + xpathExpression));
        Number number = node.numberValueOf(xpathExpression);
        if (number != null) {
            return number.longValue();
        }
        return 0L;
    }

    public long getElements() {
        return this.elements;
    }

    public long getClasses() {
        return this.classes;
    }

    public long getMethods() {
        return this.methods;
    }

    public double getLineRate() {
        return this.lineRate;
    }

    public String getCsv() {
        return this.csv;
    }

    public long getAssemblies() {
        return this.assemblies;
    }

    public long getLinesNotExecuted() {
        return this.linesNotExecuted;
    }
}

