/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.ncover;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.index.CustomPostBuildIndexWriter;
import com.atlassian.bamboo.index.PostChainIndexWriter;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import java.text.NumberFormat;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.jetbrains.annotations.NotNull;

public class NCoverPostBuildIndexWriter
implements CustomPostBuildIndexWriter,
PostChainIndexWriter {
    private static final Logger log = Logger.getLogger(NCoverPostBuildIndexWriter.class);

    public void updateIndexDocument(@NotNull Document document, @NotNull BuildResultsSummary resultsSummary) {
        this.updateIndex(document, (ResultsSummary)resultsSummary);
    }

    public void updateIndexDocument(@NotNull Document document, @NotNull ChainResultsSummary resultsSummary) {
        this.updateIndex(document, (ResultsSummary)resultsSummary);
    }

    private void updateIndex(Document document, ResultsSummary resultsSummary) {
        String coverStr = (String)resultsSummary.getCustomBuildData().get("NCOVER_LINE_RATE");
        if (coverStr == null) {
            return;
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        try {
            Number number = numberFormat.parse(coverStr);
            double coverDbl = number.doubleValue();
            DoubleField field = new DoubleField("NCOVER_LINE_RATE", coverDbl, Field.Store.YES);
            document.add((IndexableField)field);
        }
        catch (ParseException e) {
            log.error((Object)e);
        }
    }
}

