/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.nant;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ErrorMemorisingInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.LogMemorisingInterceptor;
import com.atlassian.bamboo.plugin.dotnet.support.DotNetLogHelper;
import com.atlassian.bamboo.process.CommandlineStringUtils;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.CurrentResult;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class NantTaskType
implements CommonTaskType {
    private static final Logger log = Logger.getLogger(NantTaskType.class);
    public static final String NANT_CAPABILITY_PREFIX = "system.builder.nant";
    public static final String ENVIRONMENT = "environmentVariables";
    public static final String LABEL = "label";
    public static final String BUILD_FILE = "buildFile";
    public static final String TARGET = "target";
    public static final String OPTIONS = "options";
    public static final String EXECUTABLE_NAME = SystemUtils.IS_OS_WINDOWS ? "nant.exe" : "nant";
    private static final int LINES_TO_PARSE_FOR_ERRORS = 200;
    private final ProcessService processService;
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private final CapabilityContext capabilityContext;

    public NantTaskType(ProcessService processService, EnvironmentVariableAccessor environmentVariableAccessor, CapabilityContext capabilityContext) {
        this.processService = processService;
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.capabilityContext = capabilityContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskResult execute(@NotNull CommonTaskContext commonTaskContext) throws TaskException {
        BuildLogger buildLogger = commonTaskContext.getBuildLogger();
        CurrentResult currentBuildResult = commonTaskContext.getCommonContext().getCurrentResult();
        LogMemorisingInterceptor recentLogLines = new LogMemorisingInterceptor(200);
        ErrorMemorisingInterceptor errorLines = ErrorMemorisingInterceptor.newInterceptor();
        buildLogger.getInterceptorStack().add((LogInterceptor)recentLogLines);
        buildLogger.getInterceptorStack().add((LogInterceptor)errorLines);
        try {
            Map<String, String> environment = this.getCustomEnvironment(commonTaskContext);
            String executable = this.getExecutablePath(commonTaskContext);
            String buildFile = this.getBuildFile(commonTaskContext);
            String options = this.getOptions(commonTaskContext);
            String target = this.getTarget(commonTaskContext);
            ArrayList<String> command = new ArrayList<String>();
            command.add(executable);
            if (StringUtils.isNotEmpty((CharSequence)buildFile)) {
                command.add("-buildfile:" + buildFile);
            }
            command.addAll(CommandlineStringUtils.tokeniseCommandline((String)options));
            command.addAll(CommandlineStringUtils.tokeniseCommandline((String)target));
            TaskResult taskResult = TaskResultBuilder.newBuilder((CommonTaskContext)commonTaskContext).checkReturnCode(this.processService.executeExternalProcess(commonTaskContext, new ExternalProcessBuilder().env(environment).command(command).workingDirectory(commonTaskContext.getWorkingDirectory()))).build();
            return taskResult;
        }
        finally {
            currentBuildResult.addBuildErrors(errorLines.getErrorStringList());
            currentBuildResult.addBuildErrors(DotNetLogHelper.parseErrorOutput(recentLogLines.getLogEntries()));
        }
    }

    private Map<String, String> getCustomEnvironment(CommonTaskContext taskContext) {
        return this.environmentVariableAccessor.splitEnvironmentAssignments((String)taskContext.getConfigurationMap().get((Object)ENVIRONMENT));
    }

    private String getOptions(@NotNull CommonTaskContext commonTaskContext) {
        return (String)commonTaskContext.getConfigurationMap().get((Object)OPTIONS);
    }

    public String getTarget(@NotNull CommonTaskContext commonTaskContext) {
        return (String)commonTaskContext.getConfigurationMap().get((Object)TARGET);
    }

    private String getBuildFile(@NotNull CommonTaskContext commonTaskContext) {
        return (String)commonTaskContext.getConfigurationMap().get((Object)BUILD_FILE);
    }

    String getExecutablePath(@NotNull CommonTaskContext taskContext) throws TaskException {
        File executableFile = this.getExecutableFile(taskContext);
        if (!executableFile.exists()) {
            throw new TaskException("Executable '" + EXECUTABLE_NAME + "'  does not exist at path '" + executableFile.getPath() + "'");
        }
        return executableFile.getPath();
    }

    File getExecutableFile(@NotNull CommonTaskContext commonTaskContext) {
        String label = (String)commonTaskContext.getConfigurationMap().get((Object)LABEL);
        Preconditions.checkNotNull((Object)label, (Object)"Label");
        String capabilityKey = "system.builder.nant." + label;
        Capability capability = this.capabilityContext.getCapabilitySet().getCapability(capabilityKey);
        Preconditions.checkNotNull((Object)capability, (Object)"Capability");
        String path = Joiner.on((String)File.separator).join((Object)capability.getValue(), (Object)"bin", new Object[]{EXECUTABLE_NAME});
        File executableFile = new File(path);
        return executableFile.isAbsolute() ? executableFile : new File(commonTaskContext.getRootDirectory(), path);
    }
}

