/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.msbuild;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ErrorMemorisingInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.LogMemorisingInterceptor;
import com.atlassian.bamboo.plugin.dotnet.msbuild.MsBuildConfig;
import com.atlassian.bamboo.plugin.dotnet.support.DotNetLogHelper;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.util.SecureTemporaryFiles;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.build.CurrentResult;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class MsBuildTaskType
implements CommonTaskType {
    private static final Logger log = Logger.getLogger(MsBuildTaskType.class);
    public static final String MSBUILD_CAPABILITY_PREFIX = "system.builder.msbuild";
    public static final String PROPERTY_USE_RESPONSE_FILE = "bamboo.plugin.dotnet.msbuild.useResponseFile";
    private static final int LINES_TO_PARSE_FOR_ERRORS = 200;
    private static final SystemProperty.BooleanSystemProperty USE_RESPONSE_FILE = new SystemProperty.BooleanSystemProperty(false, true, new String[]{"bamboo.plugin.dotnet.msbuild.useResponseFile"});
    private final ProcessService processService;
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private final CapabilityContext capabilityContext;

    public MsBuildTaskType(ProcessService processService, EnvironmentVariableAccessor environmentVariableAccessor, CapabilityContext capabilityContext) {
        this.processService = processService;
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.capabilityContext = capabilityContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskResult execute(@NotNull CommonTaskContext taskContext) throws TaskException {
        TaskResult taskResult;
        BuildLogger buildLogger = taskContext.getBuildLogger();
        CurrentResult currentBuildResult = taskContext.getCommonContext().getCurrentResult();
        LogMemorisingInterceptor recentLogLines = new LogMemorisingInterceptor(200);
        ErrorMemorisingInterceptor errorLines = ErrorMemorisingInterceptor.newInterceptor();
        buildLogger.getInterceptorStack().add((LogInterceptor)recentLogLines);
        buildLogger.getInterceptorStack().add((LogInterceptor)errorLines);
        File intermediateFile = null;
        try {
            ExternalProcessBuilder epb;
            MsBuildConfig msBuildConfig = MsBuildConfig.build(taskContext, this.capabilityContext, this.environmentVariableAccessor);
            if (USE_RESPONSE_FILE.getTypedValue()) {
                intermediateFile = this.createResponseFile(taskContext, msBuildConfig);
                epb = this.epbWithResponseFile(msBuildConfig, intermediateFile);
            } else {
                intermediateFile = this.createBatchFile(msBuildConfig);
                epb = this.epbWithCommandLine(msBuildConfig, intermediateFile);
            }
            epb.env(msBuildConfig.getEnvironmentMap()).workingDirectory(taskContext.getWorkingDirectory());
            taskResult = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).checkReturnCode(this.processService.executeExternalProcess(taskContext, epb)).build();
        }
        catch (Throwable throwable) {
            FileUtils.deleteQuietly(intermediateFile);
            currentBuildResult.addBuildErrors(errorLines.getErrorStringList());
            currentBuildResult.addBuildErrors(DotNetLogHelper.parseErrorOutput(recentLogLines.getLogEntries()));
            throw throwable;
        }
        FileUtils.deleteQuietly((File)intermediateFile);
        currentBuildResult.addBuildErrors(errorLines.getErrorStringList());
        currentBuildResult.addBuildErrors(DotNetLogHelper.parseErrorOutput(recentLogLines.getLogEntries()));
        return taskResult;
    }

    private ExternalProcessBuilder epbWithCommandLine(MsBuildConfig msBuildConfig, @NotNull File batchFile) {
        return new ExternalProcessBuilder().command(Arrays.asList(batchFile.getAbsolutePath(), this.getCommand(msBuildConfig)));
    }

    private File createBatchFile(MsBuildConfig msBuildConfig) {
        File batchFile;
        String command = this.getCommand(msBuildConfig);
        SecureTemporaryFiles.FileSpecBuilder fileSpecBuilder = SecureTemporaryFiles.builder().setPrefix("epb").setSuffix(".bat").setExecutable(true);
        try {
            batchFile = SecureTemporaryFiles.create((SecureTemporaryFiles.TemporaryFileSpec)fileSpecBuilder.build());
            FileUtils.writeStringToFile((File)batchFile, (String)command);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        batchFile.setReadOnly();
        return batchFile;
    }

    private String getCommand(MsBuildConfig msBuildConfig) {
        return "\"" + msBuildConfig.getMsBuildExecutable() + "\" " + msBuildConfig.getOptions() + " " + msBuildConfig.getSolution();
    }

    private ExternalProcessBuilder epbWithResponseFile(@NotNull MsBuildConfig msBuildConfig, @NotNull File responseFile) throws TaskException {
        List<String> command = Arrays.asList(msBuildConfig.getMsBuildExecutable(), "@" + responseFile.getAbsolutePath());
        return new ExternalProcessBuilder().command(command);
    }

    private File createResponseFile(@NotNull CommonTaskContext taskContext, @NotNull MsBuildConfig msBuildConfig) throws TaskException {
        try {
            String prefix = taskContext.getCommonContext().getResultKey().getKey() + "-" + this.getClass().getSimpleName() + "-";
            File responseFile = File.createTempFile(prefix, ".rsp");
            FileUtils.writeLines((File)responseFile, (Collection)ImmutableList.of((Object)"# MSBuild response file generated by Atlassian Bamboo", (Object)msBuildConfig.getOptions(), (Object)msBuildConfig.getSolution()));
            responseFile.setReadOnly();
            return responseFile;
        }
        catch (IOException e) {
            throw new TaskException("Error while creating temporary file for script", (Throwable)e);
        }
    }
}

