package com.atlassian.bamboo.plugin.dotnet.tests.mstest;

import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.plugin.dotnet.tests.AbstractDotNetTestCollectorTaskType;
import com.atlassian.bamboo.plugin.dotnet.tests.AbstractDotNetTestReportCollector;
import com.atlassian.bamboo.task.TaskContext;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class MSTestCollectorTaskType extends AbstractDotNetTestCollectorTaskType
{
    private static final Logger log = Logger.getLogger(MSTestCollectorTaskType.class);
    // ------------------------------------------------------------------------------------------------------- Constants
    // ------------------------------------------------------------------------------------------------- Type Properties

    public static final String TEST_DIRECTORY = "mstestTestResultsDirectory";

    // ---------------------------------------------------------------------------------------------------- Dependencies
    // ---------------------------------------------------------------------------------------------------- Constructors

    public MSTestCollectorTaskType(final TestCollationService testCollationService)
    {
        super(testCollationService);
    }

    // ----------------------------------------------------------------------------------------------- Interface Methods

    @Override
    protected AbstractDotNetTestReportCollector getTestReportCollector()
    {
        return new MSTestTestReportCollector();
    }

    @Override
    protected String getFilePattern(@NotNull final TaskContext taskContext)
    {
        return taskContext.getConfigurationMap().get(TEST_DIRECTORY);
    }

    // -------------------------------------------------------------------------------------------------- Action Methods
    // -------------------------------------------------------------------------------------------------- Public Methods
    // -------------------------------------------------------------------------------------- Basic Accessors / Mutators
}
