package com.atlassian.bamboo.plugin.dotnet.tests;

import com.atlassian.bamboo.build.test.TestCollectionResult;
import com.atlassian.bamboo.build.test.TestCollectionResultBuilder;
import com.atlassian.bamboo.build.test.TestReportCollector;
import com.google.common.collect.Sets;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Set;

@ThreadSafe
public abstract class AbstractDotNetTestReportCollector implements TestReportCollector
{
    @SuppressWarnings("unused")
    private static final Logger log = Logger.getLogger(AbstractDotNetTestReportCollector.class);
    // ------------------------------------------------------------------------------------------------------- Constants
    // ------------------------------------------------------------------------------------------------- Type Properties
    // ---------------------------------------------------------------------------------------------------- Dependencies
    // ---------------------------------------------------------------------------------------------------- Constructors
    // ----------------------------------------------------------------------------------------------- Interface Methods

    @Override
    @NotNull
    public TestCollectionResult collect(@NotNull final File file) throws Exception
    {
        final TestResultsParser testResultsParser = getParser();
        final InputStream inputStream = new FileInputStream(file);
        try
        {
            testResultsParser.parse(inputStream);
        }
        finally
        {
            IOUtils.closeQuietly(inputStream);
        }

        return new TestCollectionResultBuilder()
                .addSuccessfulTestResults(testResultsParser.getSuccessfulTests())
                .addFailedTestResults(testResultsParser.getFailedTests())
                .addSkippedTestResults(testResultsParser.getInconclusiveTests())
                .build();
    }

    @Override
    @NotNull
    public Set<String> getSupportedFileExtensions()
    {
        return Sets.newHashSet("trx", "xml");
    }

    /**
     * Descendant classes must provide new instance of non thread safe parsers or reuse existing instance of thread safe parser..
     *
     * @return {@link TestResultsParser} object
     */
    @NotNull
    protected abstract TestResultsParser getParser();

    // -------------------------------------------------------------------------------------------------- Action Methods
    // -------------------------------------------------------------------------------------------------- Public Methods
    // -------------------------------------------------------------------------------------- Basic Accessors / Mutators

}
