package com.atlassian.bamboo.plugin.dotnet.ncover;

import com.atlassian.bamboo.index.CustomIndexReader;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;

/**
 * Handles reading NCover-specific values that were previously stored.
 * 
 * @author Ross Rowe
 */
public class NCoverIndexReader implements CustomIndexReader
{
    /**
     * Reads NCover properties from the <code>Document</code> and stores them in
     * the custom build data of the <code>buildResultsSummary</code>.
     *
     * @param document
     * @param buildResultsSummary
     */
    @Override
    public void extractFromDocument(Document document, BuildResultsSummary buildResultsSummary)
    {
        IndexableField field = document.getField(NCoverBuildProcessor.NCOVER_LINE_RATE);
        if (field != null)
        {
            final double nCoverLineRate = field.numericValue().doubleValue();
            buildResultsSummary.getCustomBuildData().put(NCoverBuildProcessor.NCOVER_LINE_RATE, Double.toString(nCoverLineRate));
        }
    }
}
