/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.builder.php;

import com.atlassian.bamboo.command.Command;
import com.atlassian.bamboo.plugins.builder.php.AbstractPhpUnitCommandDecorator;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloverPhpUnitCommandDecorator
extends AbstractPhpUnitCommandDecorator {
    private static final Logger log = Logger.getLogger(CloverPhpUnitCommandDecorator.class);
    static final String CLOVER_ENABLED = "custom.clover.exists";
    static final String CLOVER_XML_PATH_KEY = "custom.clover.path";
    static final String CLOVER_FILENAME = "clover.xml";

    @Override
    public boolean canDecorate(Command command) {
        return super.canDecorate(command) && Boolean.parseBoolean(this.getCustomConfiguration().get(CLOVER_ENABLED));
    }

    public List<String> decorateArguments(List<String> args) {
        String cloverCoverageFilename = this.getCloverCoverageFilename();
        if (StringUtils.isNotEmpty((String)this.getWorkingSubDirectory())) {
            cloverCoverageFilename = cloverCoverageFilename.replaceFirst("^" + this.getWorkingSubDirectory() + "/", "");
        }
        args.addAll(0, Arrays.asList("--coverage-clover", cloverCoverageFilename));
        return args;
    }

    public String getCloverCoverageFilename() {
        String cloverXmlPath = this.getCustomConfiguration().get(CLOVER_XML_PATH_KEY);
        if (StringUtils.isNotEmpty((String)cloverXmlPath)) {
            return cloverXmlPath + File.separator + CLOVER_FILENAME;
        }
        return "";
    }
}

