/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.grails;

import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ErrorMemorisingInterceptor;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.process.CommandlineStringUtils;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskState;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.util.Version;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.core.util.PropertyUtils;
import com.atlassian.utils.process.ExternalProcess;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrailsBuildTask
implements TaskType {
    private static final Logger log = Logger.getLogger(GrailsBuildTask.class);
    @VisibleForTesting
    static final String GRAILS_NON_INTERACTIVE = "--non-interactive";
    private static final String GRAILS_BUILD_PROPERTIES = "build.properties";
    private static final String GRAILS_VERSION = "grails.version";
    private static final String GRAILS_APPLICATION_PROPERTIES = "application.properties";
    private static final String APP_GRAILS_VERSION = "app.grails.version";
    @VisibleForTesting
    static final String GRAILS_UPGRADE_COMMAND_FOR_2_3_AND_LESS = "upgrade -force";
    @VisibleForTesting
    static final String GRAILS_UPGRADE_COMMAND_FOR_2_4_AND_2_5 = "set-grails-version %s";
    private static final Version GRAILS_VERSION_3_0_0 = Version.of((String)"3.0.0");
    private static final Version GRAILS_VERSION_2_4_0 = Version.of((String)"2.4.0");
    public static final String GRAILS_RUN_CLEAN_GOAL = "custom.grails.runClean";
    private final ProcessService processService;
    private final TestCollationService testCollationService;
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private final CapabilityContext capabilityContext;

    public GrailsBuildTask(ProcessService processService, TestCollationService testCollationService, EnvironmentVariableAccessor environmentVariableAccessor, CapabilityContext capabilityContext) {
        this.processService = processService;
        this.testCollationService = testCollationService;
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.capabilityContext = capabilityContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        ErrorMemorisingInterceptor errorLines = ErrorMemorisingInterceptor.newInterceptor();
        taskContext.getBuildLogger().getInterceptorStack().add((LogInterceptor)errorLines);
        try {
            TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
            Map extraEnvironmentVariables = this.environmentVariableAccessor.splitEnvironmentAssignments((String)taskContext.getConfigurationMap().get((Object)"environmentVariables"), false);
            List<ExternalProcess> externalProcesses = this.getGrailsProcesses((CommonTaskContext)taskContext, extraEnvironmentVariables);
            for (ExternalProcess externalProcess : externalProcesses) {
                externalProcess.execute();
                if (taskResultBuilder.checkReturnCode(externalProcess).getTaskState() == TaskState.SUCCESS) continue;
                break;
            }
            boolean hasTests = taskContext.getConfigurationMap().getAsBoolean("testChecked");
            String testParsingPattern = this.getTestParsingPattern((CommonTaskContext)taskContext);
            if (hasTests && testParsingPattern != null) {
                this.testCollationService.collateTestResults(taskContext, testParsingPattern);
                taskResultBuilder.checkTestFailures();
            }
            TaskResult taskResult = taskResultBuilder.build();
            return taskResult;
        }
        finally {
            taskContext.getCommonContext().getCurrentResult().addBuildErrors(errorLines.getErrorStringList());
        }
    }

    @VisibleForTesting
    List<ExternalProcess> getGrailsProcesses(@NotNull CommonTaskContext taskContext, @NotNull Map<String, String> extraEnvironmentVariables) {
        String executable = this.getExecutable(taskContext);
        LinkedList<ExternalProcess> externalProcesses = new LinkedList<ExternalProcess>();
        String installedGrailsVersion = this.getInstalledGrailsVersion(executable);
        if (this.isGrailsVersionGreaterThanProjectRequirement(installedGrailsVersion, GrailsBuildTask.getRequiredGrailsVersion(taskContext)) && this.doesGrailsHaveUpgradeCommand(installedGrailsVersion)) {
            ExternalProcess upgradeProjectProcess = this.createGrailsProcess(taskContext, executable, Collections.singletonList(this.getGrailsVersionUpgradeCommand(executable)), extraEnvironmentVariables);
            externalProcesses.add(upgradeProjectProcess);
        }
        for (List<String> grailsCommand : this.getGrailsCommandsFromConfiguration(taskContext)) {
            ExternalProcess externalProcess = this.createGrailsProcess(taskContext, executable, grailsCommand, extraEnvironmentVariables);
            externalProcesses.add(externalProcess);
        }
        return externalProcesses;
    }

    @VisibleForTesting
    ExternalProcess createGrailsProcess(@NotNull CommonTaskContext taskContext, @NotNull String executable, @NotNull List<String> command, @NotNull Map<String, String> extraEnvironmentVariables) {
        LinkedList<String> commands = new LinkedList<String>();
        commands.add(executable);
        commands.addAll(command);
        if (!command.contains(GRAILS_NON_INTERACTIVE) && this.isItSafeToAddNonInteractiveArgument(this.getInstalledGrailsVersion(executable))) {
            commands.add(GRAILS_NON_INTERACTIVE);
        }
        return this.processService.createExternalProcess(taskContext, new ExternalProcessBuilder().command(commands).env(extraEnvironmentVariables).env("GRAILS_HOME", this.getGrailsHome(taskContext)).workingDirectory(taskContext.getWorkingDirectory()));
    }

    private String getExecutable(CommonTaskContext taskContext) {
        String home = this.getGrailsHome(taskContext);
        String executableName = SystemUtils.IS_OS_WINDOWS ? "grails.bat" : "grails";
        String executableFile = Joiner.on((char)File.separatorChar).join((Object)home, (Object)(home.endsWith("bin") ? "" : "bin"), new Object[]{executableName});
        if (!new File(executableFile).exists()) {
            throw new IllegalStateException("Cannot find executable '" + executableFile + "'");
        }
        return executableFile;
    }

    @NotNull
    private String getGrailsHome(CommonTaskContext taskContext) {
        String label = (String)taskContext.getConfigurationMap().get((Object)"label");
        if (StringUtils.isEmpty((CharSequence)label)) {
            throw new IllegalStateException("Cannot find label in Grails task configuration");
        }
        String capabilityKey = "system.builder.grailsBuilder." + label;
        ReadOnlyCapabilitySet capabilitySet = this.capabilityContext.getCapabilitySet();
        if (capabilitySet == null) {
            throw new IllegalStateException("Capabilities not found in current context. This shouldn't happen.");
        }
        Capability capability = capabilitySet.getCapability(capabilityKey);
        if (capability == null) {
            throw new IllegalStateException("Cannot find capability key '" + capabilityKey + "'");
        }
        String value = capability.getValue();
        if (StringUtils.isEmpty((CharSequence)value)) {
            throw new IllegalStateException("Capability '" + capabilityKey + "' does not contain the Grails Home as its value.");
        }
        File home = new File(value);
        File homeWithLibExec = new File(home, "libexec");
        if (homeWithLibExec.exists() && homeWithLibExec.isDirectory()) {
            home = homeWithLibExec;
        }
        if (!home.exists() || !home.isDirectory()) {
            throw new IllegalStateException("Cannot find Grails home at '" + value + "'");
        }
        return home.getAbsolutePath();
    }

    @NotNull
    private String getGrailsCfgGoals(@NotNull CommonTaskContext taskContext) {
        return StringUtils.defaultString((String)((String)taskContext.getConfigurationMap().get((Object)"goals")));
    }

    private boolean isRunCleanGoal(@NotNull CommonTaskContext taskContext) {
        TaskContext buildTaskContext = (TaskContext)Narrow.to((Object)taskContext, TaskContext.class);
        if (buildTaskContext != null) {
            String runClean = (String)buildTaskContext.getBuildContext().getBuildDefinition().getCustomConfiguration().get(GRAILS_RUN_CLEAN_GOAL);
            return Boolean.valueOf(runClean);
        }
        return false;
    }

    @NotNull
    private List<List<String>> getGrailsCommandsFromConfiguration(@NotNull CommonTaskContext taskContext) {
        ArrayList commandsList = Lists.newArrayList((Object[])StringUtils.split((String)this.getGrailsCfgGoals(taskContext), (String)"\r\n"));
        if (this.isRunCleanGoal(taskContext)) {
            commandsList.add(0, "clean");
        }
        return Lists.transform((List)commandsList, CommandlineStringUtils::tokeniseCommandline);
    }

    private String getTestParsingPattern(@NotNull CommonTaskContext taskContext) {
        return (String)taskContext.getConfigurationMap().get((Object)"testResultsDirectory");
    }

    @Nullable
    public static String getRequiredGrailsVersion(@NotNull CommonTaskContext taskContext) {
        File applicationPropertiesFile = new File(taskContext.getWorkingDirectory(), GRAILS_APPLICATION_PROPERTIES);
        if (applicationPropertiesFile.exists()) {
            Properties appProperties = PropertyUtils.getPropertiesFromFile((File)applicationPropertiesFile);
            return appProperties.getProperty(APP_GRAILS_VERSION);
        }
        return null;
    }

    @Nullable
    public String getInstalledGrailsVersion(@NotNull String commandExecutable) {
        File commandFile = new File(commandExecutable);
        if (commandFile.exists()) {
            File buildPropertiesFile = new File(commandFile.getParentFile().getParent(), GRAILS_BUILD_PROPERTIES);
            if (!buildPropertiesFile.exists()) {
                buildPropertiesFile = new File(new File(buildPropertiesFile.getParent(), "libexec"), GRAILS_BUILD_PROPERTIES);
            }
            if (buildPropertiesFile.exists()) {
                Properties buildProperties = PropertyUtils.getPropertiesFromFile((File)buildPropertiesFile);
                return buildProperties.getProperty(GRAILS_VERSION);
            }
        }
        return null;
    }

    boolean isGrailsVersionGreaterThanProjectRequirement(@Nullable String frameworkVersion, @Nullable String requiredVersion) {
        if (StringUtils.isEmpty((CharSequence)requiredVersion)) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)frameworkVersion)) {
            return false;
        }
        Version req = Version.of((String)requiredVersion);
        Version framework = Version.of((String)frameworkVersion);
        return framework.isGreaterThan(req);
    }

    private boolean doesGrailsHaveUpgradeCommand(@Nullable String frameworkVersion) {
        if (StringUtils.isEmpty((CharSequence)frameworkVersion)) {
            return false;
        }
        try {
            return GRAILS_VERSION_3_0_0.isGreaterThan(Version.of((String)frameworkVersion));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            return false;
        }
    }

    @NotNull
    private String getGrailsVersionUpgradeCommand(String commandExecutable) {
        String frameworkVersion = this.getInstalledGrailsVersion(commandExecutable);
        if (StringUtils.isEmpty((CharSequence)frameworkVersion)) {
            return GRAILS_UPGRADE_COMMAND_FOR_2_3_AND_LESS;
        }
        Version framework = Version.of((String)frameworkVersion);
        if (GRAILS_VERSION_2_4_0.isGreaterThan(framework)) {
            return GRAILS_UPGRADE_COMMAND_FOR_2_3_AND_LESS;
        }
        return String.format(GRAILS_UPGRADE_COMMAND_FOR_2_4_AND_2_5, framework.toString());
    }

    private boolean isItSafeToAddNonInteractiveArgument(String frameworkVersion) {
        return !StringUtils.isEmpty((CharSequence)frameworkVersion) && GRAILS_VERSION_3_0_0.isGreaterThan(Version.of((String)frameworkVersion));
    }
}

